/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.requirements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jira.requirements.JIRARequirementsProvider;
import net.serenitybdd.plugins.jira.requirements.RequirementsAdaptor;
import net.serenitybdd.plugins.jira.requirements.RequirementsLoader;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialRequirementsLoader
implements RequirementsLoader {
    private final EnvironmentVariables environmentVariables;
    private final RequirementsAdaptor adaptor;
    private final JIRARequirementsProvider requirementsProvider;
    private final Logger logger = LoggerFactory.getLogger(SerialRequirementsLoader.class);

    public SerialRequirementsLoader(EnvironmentVariables environmentVariables, JIRARequirementsProvider requirementsProvider) {
        this.environmentVariables = environmentVariables;
        this.adaptor = new RequirementsAdaptor(environmentVariables);
        this.requirementsProvider = requirementsProvider;
    }

    @Override
    public List<Requirement> loadFrom(List<IssueSummary> rootRequirementIssues) {
        List<Requirement> requirements = Collections.synchronizedList(new ArrayList());
        long t0 = System.currentTimeMillis();
        this.logger.debug("Loading {} requirements", (Object)rootRequirementIssues.size());
        for (IssueSummary issueSummary : rootRequirementIssues) {
            Requirement requirement = this.adaptor.requirementFrom(issueSummary);
            List<Requirement> childRequirements = this.requirementsProvider.findChildrenFor(requirement, 0);
            requirements.add(requirement.withChildren(childRequirements));
        }
        this.logger.debug("Loading requirements done in {} ms", (Object)(System.currentTimeMillis() - t0));
        return requirements;
    }
}

