/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jirarequirements;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jirarequirements.JIRARequirementsConfiguration;
import net.serenitybdd.plugins.jirarequirements.JIRARequirementsProvider;
import net.serenitybdd.plugins.jirarequirements.RequirementsAdaptor;
import net.serenitybdd.plugins.jirarequirements.RequirementsLoader;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentRequirementsLoader
implements RequirementsLoader {
    private final ListeningExecutorService executorService;
    private final EnvironmentVariables environmentVariables;
    private final JIRARequirementsProvider requirementsProvider;
    private final RequirementsAdaptor adaptor;
    private final AtomicInteger queueSize = new AtomicInteger(0);
    static int DEFAULT_MAX_THREADS = 4;
    private final Logger logger = LoggerFactory.getLogger(ConcurrentRequirementsLoader.class);

    public ConcurrentRequirementsLoader(EnvironmentVariables environmentVariables, JIRARequirementsProvider requirementsProvider) {
        this.environmentVariables = environmentVariables;
        this.requirementsProvider = requirementsProvider;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.getMaxJobs()));
        this.adaptor = new RequirementsAdaptor(environmentVariables);
    }

    @Override
    public List<Requirement> loadFrom(List<IssueSummary> rootRequirementIssues) {
        final List<Requirement> requirements = Collections.synchronizedList(new ArrayList());
        long t0 = System.currentTimeMillis();
        this.logger.debug("Loading {} requirements", (Object)rootRequirementIssues.size());
        if (rootRequirementIssues.isEmpty()) {
            return ImmutableList.of();
        }
        this.queueSize.set(rootRequirementIssues.size());
        for (final IssueSummary issueSummary : rootRequirementIssues) {
            final ListenableFuture future = this.executorService.submit((Callable)new Callable<IssueSummary>(){

                @Override
                public IssueSummary call() throws Exception {
                    return issueSummary;
                }
            });
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        IssueSummary issue = (IssueSummary)future.get();
                        Requirement requirement = ConcurrentRequirementsLoader.this.adaptor.requirementFrom(issue);
                        ConcurrentRequirementsLoader.this.logger.debug("Load children for requirement {}", (Object)requirement.getName());
                        List<Requirement> childRequirements = ConcurrentRequirementsLoader.this.requirementsProvider.findChildrenFor(requirement, 0);
                        ConcurrentRequirementsLoader.this.logger.debug("Load children for requirement {} done", (Object)requirement.getName());
                        requirements.add(requirement.withChildren(childRequirements));
                        ConcurrentRequirementsLoader.this.queueSize.decrementAndGet();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }, (Executor)MoreExecutors.newDirectExecutorService());
        }
        this.waitTillEmpty();
        this.logger.debug("{} requirements loaded in {} ms", (Object)requirements.size(), (Object)(System.currentTimeMillis() - t0));
        this.logger.debug("Requirements: {}", requirements);
        return requirements;
    }

    private void waitTillQueueNotEmpty() {
        while (this.queueSize.get() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void waitTillEmpty() {
        while (this.queueSize.get() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private int getMaxJobs() {
        return this.environmentVariables.getPropertyAsInteger(JIRARequirementsConfiguration.JIRA_MAX_THREADS.getName(), Integer.valueOf(DEFAULT_MAX_THREADS));
    }
}

