/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jirarequirements;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.plugins.jira.domain.CustomFieldCast;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jirarequirements.JIRARequirementsConfiguration;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class RequirementsAdaptor {
    private final EnvironmentVariables environmentVariables;

    public RequirementsAdaptor(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public Requirement requirementFrom(IssueSummary issue) {
        Requirement baseRequirement = Requirement.named((String)issue.getSummary()).withOptionalCardNumber(issue.getKey()).withType(issue.getType()).withNarrative(this.narrativeTextFrom(issue)).withReleaseVersions(issue.getFixVersions());
        for (String fieldName : this.definedCustomFields()) {
            if (!issue.customField(fieldName).isPresent()) continue;
            String value = ((CustomFieldCast)issue.customField(fieldName).get()).asString();
            String renderedValue = (String)issue.getRendered().customField(fieldName).get();
            baseRequirement = baseRequirement.withCustomField(fieldName).setTo(value, renderedValue);
        }
        return baseRequirement;
    }

    private String narrativeTextFrom(IssueSummary issue) {
        Optional<String> customFieldName = Optional.ofNullable(this.environmentVariables.getProperty(JIRARequirementsConfiguration.JIRA_CUSTOM_NARRATIVE_FIELD.getName()));
        if (customFieldName.isPresent()) {
            return this.customFieldNameFor(issue, customFieldName.get()).orElse((String)ObjectUtils.firstNonNull((Object[])new String[]{issue.getRendered().getDescription(), ""}));
        }
        return issue.getRendered().getDescription();
    }

    private List<String> definedCustomFields() {
        ArrayList<String> customFields = new ArrayList<String>();
        int customFieldIndex = 1;
        while (this.addCustomFieldIfDefined(this.environmentVariables, customFields, this.customFieldNumber(customFieldIndex++))) {
        }
        return customFields;
    }

    private Optional<String> customFieldNameFor(IssueSummary issue, String customFieldName) {
        if (issue.customField(customFieldName).isPresent()) {
            return Optional.of(((CustomFieldCast)issue.customField(customFieldName).get()).asString());
        }
        return Optional.empty();
    }

    private boolean addCustomFieldIfDefined(EnvironmentVariables environmentVariables, List<String> customFields, String customField) {
        String customFieldName = environmentVariables.getProperty(customField);
        if (StringUtils.isNotEmpty((CharSequence)customFieldName)) {
            customFields.add(customFieldName);
            return true;
        }
        return false;
    }

    private String customFieldNumber(int customFieldIndex) {
        return JIRARequirementsConfiguration.JIRA_CUSTOM_FIELD.getName() + "." + customFieldIndex;
    }
}

