/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jirarequirements;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.plugins.jira.client.JerseyJiraClient;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jira.model.JQLException;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.requirements.model.Requirement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueTagReader {
    private final Logger logger = LoggerFactory.getLogger(IssueTagReader.class);
    private final List<Requirement> flattenedRequirements;
    private final JerseyJiraClient jiraClient;
    private final String projectKey;
    private final List<TestTag> tags = Lists.newArrayList();

    public IssueTagReader(JerseyJiraClient jiraClient, List<Requirement> flattenedRequirements, String projectKey) {
        this.flattenedRequirements = flattenedRequirements;
        this.jiraClient = jiraClient;
        this.projectKey = projectKey;
    }

    public IssueTagReader addVersionTags(String issueKey) {
        String decodedIssueKey = this.decoded(issueKey);
        try {
            Optional issue = this.jiraClient.findByKey(issueKey);
            if (issue.isPresent()) {
                this.addVersionTags(((IssueSummary)issue.get()).getFixVersions());
            }
        }
        catch (JQLException e) {
            this.logger.warn("Could not read versions for issue " + decodedIssueKey, (Throwable)e);
        }
        return this;
    }

    private void addVersionTags(List<String> versions) {
        for (String version : versions) {
            TestTag versionTag = TestTag.withName((String)version).andType("Version");
            this.tags.add(versionTag);
        }
    }

    public IssueTagReader addRequirementTags(String issueKey) {
        String decodedIssueKey = this.decoded(issueKey);
        List<Requirement> parentRequirements = this.getAssociatedRequirementsOf(decodedIssueKey);
        for (Requirement parentRequirement : parentRequirements) {
            this.tags.add(parentRequirement.asTag());
        }
        return this;
    }

    public IssueTagReader addIssueTags(String issueKey) {
        String decodedIssueKey = this.decoded(issueKey);
        Optional behaviourIssue = Optional.empty();
        try {
            behaviourIssue = this.jiraClient.findByKey(decodedIssueKey);
        }
        catch (JQLException e) {
            this.logger.warn("Could not read tags for issue " + decodedIssueKey, (Throwable)e);
        }
        if (behaviourIssue.isPresent()) {
            this.tags.add(TestTag.withName((String)((IssueSummary)behaviourIssue.get()).getSummary()).andType(((IssueSummary)behaviourIssue.get()).getType()));
        }
        return this;
    }

    public List<TestTag> getTags() {
        return ImmutableList.copyOf(this.tags);
    }

    private List<Requirement> getAssociatedRequirementsOf(String issueKey) {
        for (Requirement requirement : this.flattenedRequirements) {
            if (!requirement.getCardNumber().equalsIgnoreCase(issueKey)) continue;
            ArrayList associatedRequirements = Lists.newArrayList((Object[])new Requirement[]{requirement});
            associatedRequirements.addAll(this.getParentRequirementsOf(issueKey));
            return ImmutableList.copyOf((Collection)associatedRequirements);
        }
        return ImmutableList.of();
    }

    private List<Requirement> getParentRequirementsOf(String issueKey) {
        ArrayList parentRequirements = Lists.newArrayList();
        Optional<Requirement> parentRequirement = this.getParentRequirementOf(issueKey);
        if (parentRequirement.isPresent()) {
            parentRequirements.add(parentRequirement.get());
            parentRequirements.addAll(this.getParentRequirementsOf(parentRequirement.get().getCardNumber()));
        }
        return parentRequirements;
    }

    private Optional<Requirement> getParentRequirementOf(String key) {
        for (Requirement requirement : this.flattenedRequirements) {
            if (!this.containsRequirementWithId(key, requirement.getChildren())) continue;
            return Optional.of(requirement);
        }
        return Optional.empty();
    }

    private boolean containsRequirementWithId(String key, List<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            if (!requirement.getCardNumber().equals(key)) continue;
            return true;
        }
        return false;
    }

    private String decoded(String issueKey) {
        if (((String)issueKey).startsWith("#")) {
            issueKey = ((String)issueKey).substring(1);
        }
        if (StringUtils.isNumeric((CharSequence)issueKey)) {
            issueKey = this.projectKey + "-" + (String)issueKey;
        }
        return issueKey;
    }
}

