/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import net.serenitybdd.junit.runners.TestClassAnnotations;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.statistics.TestCount;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runners.model.TestClass;

public class TestConfiguration {
    private final Class<?> testClass;
    private final Configuration configuration;
    private final TestCount testCount;
    private final TestClassAnnotations theTestIsAnnotated;

    public TestConfiguration(Class<?> testClass, Configuration configuration) {
        this.testClass = testClass;
        this.configuration = configuration;
        this.testCount = (TestCount)Injectors.getInjector().getInstance(TestCount.class);
        this.theTestIsAnnotated = TestClassAnnotations.forTestClass(testClass);
    }

    public boolean shouldRetryTest() {
        return ThucydidesSystemProperty.JUNIT_RETRY_TESTS.booleanFrom(this.configuration.getEnvironmentVariables());
    }

    public int getMaxRetries() {
        return this.shouldRetryTest() ? this.configuration.maxRetries() : 0;
    }

    public boolean shouldClearMetadata() {
        return ThucydidesSystemProperty.THUCYDIDES_MAINTAIN_SESSION.booleanFrom(this.configuration.getEnvironmentVariables()) == false;
    }

    public static TestConfigurationBuilder forClass(Class<?> testClass) {
        return new TestConfigurationBuilder(testClass);
    }

    public boolean needsToRestartTheBrowser() {
        return this.isAWebTest() && this.restartBrowserBeforeTest();
    }

    protected boolean restartBrowserBeforeTest() {
        return this.notAUniqueSession() || this.dueForPeriodicBrowserReset();
    }

    private boolean dueForPeriodicBrowserReset() {
        return this.shouldRestartEveryNthTest() && this.currentTestNumber() % this.restartFrequency() == 0;
    }

    private boolean notAUniqueSession() {
        return !this.isUniqueSession();
    }

    protected boolean isUniqueSession() {
        return this.theTestIsAnnotated.toUseAUniqueSession() || this.configuration.shouldUseAUniqueBrowser();
    }

    protected boolean shouldRestartEveryNthTest() {
        return this.restartFrequency() > 0;
    }

    protected int restartFrequency() {
        return this.configuration.getRestartFrequency();
    }

    protected int currentTestNumber() {
        return this.testCount.getCurrentTestNumber();
    }

    public boolean shouldClearTheBrowserSession() {
        return this.isAWebTest() && TestCaseAnnotations.shouldClearCookiesBeforeEachTestIn((Class)this.testClass().getJavaClass());
    }

    private TestClass testClass() {
        return new TestClass(this.testClass);
    }

    public boolean isAWebTest() {
        return TestCaseAnnotations.isWebTest((Class)this.testClass().getJavaClass());
    }

    public static class TestConfigurationBuilder {
        private final Class<?> testClass;

        public TestConfigurationBuilder(Class<?> testClass) {
            TestClass t = new TestClass(testClass);
            this.testClass = testClass;
        }

        public TestConfiguration withSystemConfiguration(Configuration configuration) {
            return new TestConfiguration(this.testClass, configuration);
        }
    }
}

