/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.util.List;
import net.serenitybdd.junit.runners.DataDrivenAnnotations;
import net.serenitybdd.junit.runners.QualifiedTestsRunner;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

class TestClassRunnerForParameters
extends QualifiedTestsRunner {
    private final int parameterSetNumber;
    private final DataTable parametersTable;

    TestClassRunnerForParameters(Class<?> type, Configuration configuration, WebDriverFactory webDriverFactory, BatchManager batchManager, DataTable parametersTable, int i) throws InitializationError {
        super(type, configuration, webDriverFactory, batchManager);
        this.parametersTable = parametersTable;
        this.parameterSetNumber = i;
    }

    @Override
    protected JUnitStepListener initListenersUsing(Pages pageFactory) {
        this.setStepListener(JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withPageFactory(pageFactory).and().withParameterSetNumber(this.parameterSetNumber).and().withParametersTable(this.parametersTable).and().withTestClass(this.getTestClass().getJavaClass()).and().build());
        return this.getStepListener();
    }

    @Override
    protected JUnitStepListener initListeners() {
        this.setStepListener(JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withParameterSetNumber(this.parameterSetNumber).and().withParametersTable(this.parametersTable).and().withTestClass(this.getTestClass().getJavaClass()).and().build());
        return this.getStepListener();
    }

    @Override
    protected Object initializeTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
    }

    private Object[] computeParams() throws Exception {
        try {
            DataTableRow row = (DataTableRow)this.parametersTable.getRows().get(this.parameterSetNumber);
            return row.getValues().toArray();
        }
        catch (ClassCastException cause) {
            throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), DataDrivenAnnotations.forClass(this.getTestClass()).getTestDataMethod().getName()), cause);
        }
    }

    protected String getName() {
        String firstParameter = ((DataTableRow)this.parametersTable.getRows().get(this.parameterSetNumber)).getValues().get(0).toString();
        return String.format("[%s]", firstParameter);
    }

    protected String testName(FrameworkMethod method) {
        return String.format("%s[%s]", method.getName(), this.parameterSetNumber);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    @Override
    protected void generateReports() {
    }
}

