/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import net.serenitybdd.junit.runners.TestClassAnnotations;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runners.model.TestClass;

public class TestConfiguration {
    private final Class<?> testClass;
    private final Configuration configuration;
    private final TestClassAnnotations theTestIsAnnotated;

    public TestConfiguration(Class<?> testClass, Configuration configuration) {
        this.testClass = testClass;
        this.configuration = configuration;
        this.theTestIsAnnotated = TestClassAnnotations.forTestClass(testClass);
    }

    public boolean shouldClearMetadata() {
        return ThucydidesSystemProperty.THUCYDIDES_MAINTAIN_SESSION.booleanFrom(this.configuration.getEnvironmentVariables()) == false;
    }

    public static TestConfigurationBuilder forClass(Class<?> testClass) {
        return new TestConfigurationBuilder(testClass);
    }

    protected boolean isUniqueSession() {
        return this.theTestIsAnnotated.toUseAUniqueSession() || this.configuration.shouldUseAUniqueBrowser();
    }

    public boolean shouldClearTheBrowserSession() {
        return this.isAWebTest() && TestCaseAnnotations.shouldClearCookiesBeforeEachTestIn((Class)this.testClass().getJavaClass());
    }

    public boolean shouldResetStepLibraries() {
        return !TestCaseAnnotations.shouldUsePersistantStepLibraries(this.testClass);
    }

    private TestClass testClass() {
        return new TestClass(this.testClass);
    }

    public boolean isAWebTest() {
        return TestCaseAnnotations.isWebTest((Class)this.testClass().getJavaClass());
    }

    public static class TestConfigurationBuilder {
        private final Class<?> testClass;

        public TestConfigurationBuilder(Class<?> testClass) {
            this.testClass = testClass;
        }

        public TestConfiguration withSystemConfiguration(Configuration configuration) {
            return new TestConfiguration(this.testClass, configuration);
        }
    }
}

