/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.environment.WebDriverConfiguredEnvironment;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.junit.runners.FailureDetectingStepListener;
import net.serenitybdd.junit.runners.FailureRerunner;
import net.serenitybdd.junit.runners.FailureRerunnerXml;
import net.serenitybdd.junit.runners.SerenityStatement;
import net.serenitybdd.junit.runners.TestClassRunnerForParameters;
import net.serenitybdd.junit.runners.TestConfiguration;
import net.serenitybdd.junit.runners.TestMethodAnnotations;
import net.serenitybdd.junit.runners.TestMethodConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.annotations.ManualTestMarkedAsError;
import net.thucydides.core.annotations.ManualTestMarkedAsFailure;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.batches.BatchManagerProvider;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.guice.webdriver.WebDriverModule;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.steps.stepdata.StepData;
import net.thucydides.core.tags.TagScanner;
import net.thucydides.core.tags.Taggable;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityRunner
extends BlockJUnit4ClassRunner
implements Taggable {
    private StepFactory stepFactory;
    private Pages pages;
    private final WebdriverManager webdriverManager;
    private String requestedDriver;
    private ReportService reportService;
    private final TestConfiguration theTest;
    private FailureRerunner failureRerunner;
    private JUnitStepListener stepListener;
    private PageObjectDependencyInjector dependencyInjector;
    private FailureDetectingStepListener failureDetectingStepListener;
    private DriverConfiguration configuration;
    private TagScanner tagScanner;
    private BatchManager batchManager;
    private final Logger logger = LoggerFactory.getLogger(SerenityRunner.class);

    public Pages getPages() {
        return this.pages;
    }

    public SerenityRunner(Class<?> klass) throws InitializationError {
        this(klass, Injectors.getInjector((Module)new WebDriverModule()));
    }

    public SerenityRunner(Class<?> klass, Module module) throws InitializationError {
        this(klass, Injectors.getInjector((Module)module));
    }

    public SerenityRunner(Class<?> klass, Injector injector) throws InitializationError {
        this(klass, ThucydidesWebDriverSupport.getWebdriverManager(), (DriverConfiguration)injector.getInstance(DriverConfiguration.class), (BatchManager)injector.getInstance(BatchManager.class));
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws InitializationError {
        this(klass, webDriverFactory, WebDriverConfiguredEnvironment.getDriverConfiguration());
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory, DriverConfiguration configuration) throws InitializationError {
        this(klass, webDriverFactory, configuration, new BatchManagerProvider((Configuration)configuration).get());
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory, DriverConfiguration configuration, BatchManager batchManager) throws InitializationError {
        this(klass, ThucydidesWebDriverSupport.getWebdriverManager((WebDriverFactory)webDriverFactory, (DriverConfiguration)configuration), configuration, batchManager);
    }

    public SerenityRunner(Class<?> klass, BatchManager batchManager) throws InitializationError {
        this(klass, ThucydidesWebDriverSupport.getWebdriverManager(), WebDriverConfiguredEnvironment.getDriverConfiguration(), batchManager);
    }

    public SerenityRunner(Class<?> klass, WebdriverManager webDriverManager, DriverConfiguration configuration, BatchManager batchManager) throws InitializationError {
        super(klass);
        this.theTest = TestConfiguration.forClass(klass).withSystemConfiguration((Configuration)configuration);
        this.webdriverManager = webDriverManager;
        this.configuration = configuration;
        this.requestedDriver = this.getSpecifiedDriver(klass);
        this.tagScanner = new TagScanner(configuration.getEnvironmentVariables());
        this.failureDetectingStepListener = new FailureDetectingStepListener();
        this.failureRerunner = new FailureRerunnerXml((Configuration)configuration);
        if (TestCaseAnnotations.supportsWebTests(klass)) {
            this.checkRequestedDriverType();
        }
        this.batchManager = batchManager;
        batchManager.registerTestCase(klass);
    }

    private String getSpecifiedDriver(Class<?> klass) {
        if (ManagedWebDriverAnnotatedField.hasManagedWebdriverField(klass)) {
            return ManagedWebDriverAnnotatedField.findFirstAnnotatedField(klass).getDriver();
        }
        return null;
    }

    protected DriverConfiguration getConfiguration() {
        return this.configuration;
    }

    protected BatchManager getBatchManager() {
        return this.batchManager;
    }

    private void checkRequestedDriverType() {
        if (this.requestedDriverSpecified()) {
            SupportedWebDriver.getDriverTypeFor((String)this.requestedDriver);
        } else {
            this.getConfiguration().getDriverType();
        }
    }

    private boolean requestedDriverSpecified() {
        return !StringUtils.isEmpty((CharSequence)this.requestedDriver);
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.getReportService().useQualifier(qualifier);
    }

    public void run(RunNotifier notifier) {
        if (this.skipThisTest()) {
            return;
        }
        try {
            RunNotifier localNotifier = this.initializeRunNotifier(notifier);
            StepEventBus.getEventBus().registerListener((StepListener)this.failureDetectingStepListener);
            super.run(localNotifier);
            this.fireNotificationsBasedOnTestResultsTo(notifier);
        }
        catch (Throwable someFailure) {
            someFailure.printStackTrace();
            throw someFailure;
        }
        finally {
            this.notifyTestSuiteFinished();
            this.generateReports();
            Map<String, List<String>> failedTests = this.stepListener.getFailedTests();
            this.failureRerunner.recordFailedTests(failedTests);
            this.dropListeners(notifier);
            StepEventBus.getEventBus().dropAllListeners();
        }
    }

    private Optional<TestOutcome> latestOutcome() {
        if (StepEventBus.getEventBus().getBaseStepListener().getTestOutcomes().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(StepEventBus.getEventBus().getBaseStepListener().getTestOutcomes().get(0));
    }

    private void fireNotificationsBasedOnTestResultsTo(RunNotifier notifier) {
        if (!this.latestOutcome().isPresent()) {
            return;
        }
    }

    private void notifyTestSuiteFinished() {
        try {
            if (this.dataDrivenTest()) {
                StepEventBus.getEventBus().exampleFinished();
            } else {
                StepEventBus.getEventBus().testSuiteFinished();
            }
        }
        catch (Throwable listenerException) {
            this.logger.error("Test event bus error: " + listenerException.getMessage(), listenerException);
        }
    }

    private boolean dataDrivenTest() {
        return this instanceof TestClassRunnerForParameters;
    }

    private void dropListeners(RunNotifier notifier) {
        JUnitStepListener listener = this.getStepListener();
        notifier.removeListener((RunListener)listener);
        this.getStepListener().dropListeners();
    }

    protected void generateReports() {
        this.generateReportsFor(this.getTestOutcomes());
    }

    private boolean skipThisTest() {
        return this.testNotInCurrentBatch();
    }

    private boolean testNotInCurrentBatch() {
        return this.batchManager != null && !this.batchManager.shouldExecuteThisTest(this.getDescription().testCount());
    }

    protected JUnitStepListener getStepListener() {
        if (this.stepListener == null) {
            this.buildAndConfigureListeners();
        }
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    private void buildAndConfigureListeners() {
        this.initStepEventBus();
        if (this.webtestsAreSupported()) {
            ThucydidesWebDriverSupport.initialize((String)this.requestedDriver);
            WebDriver driver = ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver();
            this.initPagesObjectUsing(driver);
            this.setStepListener(this.initListenersUsing(this.getPages()));
            this.initStepFactoryUsing(this.getPages());
        } else {
            this.setStepListener(this.initListeners());
            this.initStepFactory();
        }
    }

    private RunNotifier initializeRunNotifier(RunNotifier notifier) {
        notifier.addListener((RunListener)this.getStepListener());
        return notifier;
    }

    private int maxRetries() {
        return ThucydidesSystemProperty.TEST_RETRY_COUNT.integerFrom(this.configuration.getEnvironmentVariables(), 0);
    }

    protected void initStepEventBus() {
        StepEventBus.getEventBus().clear();
    }

    private void initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver, (Configuration)this.getConfiguration());
        this.dependencyInjector = new PageObjectDependencyInjector(this.pages);
    }

    protected JUnitStepListener initListenersUsing(Pages pageFactory) {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withPageFactory(pageFactory).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    protected JUnitStepListener initListeners() {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    private boolean webtestsAreSupported() {
        return TestCaseAnnotations.supportsWebTests((Class)this.getTestClass().getJavaClass());
    }

    private void initStepFactoryUsing(Pages pagesObject) {
        this.stepFactory = StepFactory.getFactory().usingPages(pagesObject);
    }

    private void initStepFactory() {
        this.stepFactory = StepFactory.getFactory();
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
        this.getReportService().generateConfigurationsReport();
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        TestMethodConfiguration theMethod = TestMethodConfiguration.forMethod(method);
        this.clearMetadataIfRequired();
        this.resetStepLibrariesIfRequired();
        if (!this.failureRerunner.hasToRunTest(method.getDeclaringClass().getCanonicalName(), method.getMethod().getName())) {
            return;
        }
        if (this.shouldSkipTest(method)) {
            return;
        }
        if (theMethod.isManual()) {
            this.markAsManual(method).accept(notifier);
            return;
        }
        if (theMethod.isPending()) {
            this.markAsPending(method);
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        this.processTestMethodAnnotationsFor(method);
        StepEventBus.getEventBus().initialiseSession();
        this.prepareBrowserForTest();
        this.additionalBrowserCleanup();
        this.performRunChild(method, notifier);
        if (this.failureDetectingStepListener.lastTestFailed() && this.maxRetries() > 0) {
            this.retryAtMost(this.maxRetries(), new RerunSerenityTest(method, notifier));
        }
    }

    private void retryAtMost(int remainingTries, RerunTest rerunTest) {
        if (remainingTries <= 0) {
            return;
        }
        this.logger.info(rerunTest.toString() + ": attempt " + (this.maxRetries() - remainingTries));
        StepEventBus.getEventBus().cancelPreviousTest();
        rerunTest.perform();
        if (this.failureDetectingStepListener.lastTestFailed()) {
            this.retryAtMost(remainingTries - 1, rerunTest);
        } else {
            StepEventBus.getEventBus().lastTestPassedAfterRetries(remainingTries, this.failureDetectingStepListener.getFailureMessages(), this.failureDetectingStepListener.getTestFailureCause());
        }
    }

    private void performRunChild(FrameworkMethod method, RunNotifier notifier) {
        super.runChild(method, notifier);
    }

    private void clearMetadataIfRequired() {
        if (this.theTest.shouldClearMetadata()) {
            Serenity.getCurrentSession().clearMetaData();
        }
    }

    private void resetStepLibrariesIfRequired() {
        if (this.theTest.shouldResetStepLibraries()) {
            this.stepFactory.reset();
        }
    }

    protected void additionalBrowserCleanup() {
    }

    private boolean shouldSkipTest(FrameworkMethod method) {
        return !this.tagScanner.shouldRunMethod(this.getTestClass().getJavaClass(), method.getName());
    }

    private void markAsPending(FrameworkMethod method) {
        this.testStarted(method);
        StepEventBus.getEventBus().testPending();
        StepEventBus.getEventBus().testFinished();
    }

    private Consumer<RunNotifier> markAsManual(FrameworkMethod method) {
        TestMethodConfiguration theMethod = TestMethodConfiguration.forMethod(method);
        this.testStarted(method);
        StepEventBus.getEventBus().testIsManual();
        StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome().ifPresent(outcome -> {
            outcome.setResult(theMethod.getManualResult());
            if (theMethod.getManualResult() == TestResult.FAILURE) {
                outcome.setTestFailureMessage(this.manualReasonDeclaredIn(theMethod));
            }
        });
        switch (theMethod.getManualResult()) {
            case SUCCESS: {
                StepEventBus.getEventBus().testFinished();
                return notifier -> notifier.fireTestFinished(Description.EMPTY);
            }
            case FAILURE: {
                ManualTestMarkedAsFailure failure = new ManualTestMarkedAsFailure(this.manualReasonDeclaredIn(theMethod));
                StepEventBus.getEventBus().testFailed((Throwable)failure);
                return arg_0 -> SerenityRunner.lambda$markAsManual$2(method, (Throwable)failure, arg_0);
            }
            case ERROR: 
            case COMPROMISED: 
            case UNSUCCESSFUL: {
                ManualTestMarkedAsError error = new ManualTestMarkedAsError(this.manualReasonDeclaredIn(theMethod));
                StepEventBus.getEventBus().testFailed((Throwable)error);
                return arg_0 -> SerenityRunner.lambda$markAsManual$3(method, (Throwable)error, arg_0);
            }
            case IGNORED: {
                StepEventBus.getEventBus().testIgnored();
                return notifier -> notifier.fireTestIgnored(Description.createTestDescription((Class)method.getDeclaringClass(), (String)method.getName()));
            }
            case SKIPPED: {
                StepEventBus.getEventBus().testSkipped();
                return notifier -> notifier.fireTestIgnored(Description.createTestDescription((Class)method.getDeclaringClass(), (String)method.getName()));
            }
        }
        StepEventBus.getEventBus().testPending();
        return notifier -> notifier.fireTestIgnored(Description.createTestDescription((Class)method.getDeclaringClass(), (String)method.getName()));
    }

    private String manualReasonDeclaredIn(TestMethodConfiguration theMethod) {
        return theMethod.getManualResultReason().isEmpty() ? "Manual test failure" : "Manual test failure: " + theMethod.getManualResultReason();
    }

    private void testStarted(FrameworkMethod method) {
        this.getStepListener().testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
    }

    private void processTestMethodAnnotationsFor(FrameworkMethod method) {
        if (this.isIgnored(method)) {
            this.testStarted(method);
            StepEventBus.getEventBus().testIgnored();
            StepEventBus.getEventBus().testFinished();
        }
    }

    protected void prepareBrowserForTest() {
        if (this.theTest.shouldClearTheBrowserSession()) {
            WebdriverProxyFactory.clearBrowserSession((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.webtestsAreSupported()) {
            this.injectDriverInto(test);
            this.initPagesObjectUsing(this.driverFor(method));
            this.injectAnnotatedPagesObjectInto(test);
            this.initStepFactoryUsing(this.getPages());
        }
        this.injectScenarioStepsInto(test);
        this.injectEnvironmentVariablesInto(test);
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new SerenityStatement(baseStatement, (StepPublisher)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    protected void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase((Object)testCase).injectDrivers(ThucydidesWebDriverSupport.getDriver(), ThucydidesWebDriverSupport.getWebdriverManager());
        this.dependencyInjector.injectDependenciesInto(testCase);
    }

    protected WebDriver driverFor(FrameworkMethod method) {
        if (TestMethodAnnotations.forTest(method).isDriverSpecified()) {
            String testSpecificDriver = TestMethodAnnotations.forTest(method).specifiedDriver();
            String driverOptions = TestMethodAnnotations.forTest(method).driverOptions();
            return this.getDriver(testSpecificDriver, driverOptions);
        }
        return this.getDriver();
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injector().injectScenarioStepsInto(testCase, this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injector().injectAnnotatedPagesObjectInto(testCase, this.pages);
    }

    protected void injectEnvironmentVariablesInto(Object testCase) {
        EnvironmentDependencyInjector environmentDependencyInjector = new EnvironmentDependencyInjector();
        environmentDependencyInjector.injectDependenciesInto(testCase);
    }

    protected WebDriver getDriver() {
        return StringUtils.isEmpty((CharSequence)this.requestedDriver) ? ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver() : ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver(this.requestedDriver);
    }

    protected WebDriver getDriver(String driver, String driverOptions) {
        return StringUtils.isEmpty((CharSequence)driver) ? ThucydidesWebDriverSupport.getWebdriverManager().withOptions(driverOptions).getWebdriver() : ThucydidesWebDriverSupport.getWebdriverManager().withOptions(driverOptions).getWebdriver(driver);
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }

    private static /* synthetic */ void lambda$markAsManual$3(FrameworkMethod method, Throwable error, RunNotifier notifier) {
        notifier.fireTestFailure(new Failure(Description.createTestDescription((Class)method.getDeclaringClass(), (String)method.getName()), error));
    }

    private static /* synthetic */ void lambda$markAsManual$2(FrameworkMethod method, Throwable failure, RunNotifier notifier) {
        notifier.fireTestFailure(new Failure(Description.createTestDescription((Class)method.getDeclaringClass(), (String)method.getName()), failure));
    }

    class RerunSerenityTest
    implements RerunTest {
        private final FrameworkMethod method;
        private final RunNotifier notifier;

        RerunSerenityTest(FrameworkMethod method, RunNotifier notifier) {
            this.method = method;
            this.notifier = notifier;
        }

        @Override
        public void perform() {
            SerenityRunner.this.performRunChild(this.method, this.notifier);
        }

        public String toString() {
            return "Retrying " + this.method.getDeclaringClass() + " " + this.method.getMethod().getName();
        }
    }

    static interface RerunTest {
        public void perform();
    }
}

