/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.junit.runners.QualifierFinder;
import net.serenitybdd.junit.runners.SerenityRunner;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.junit.runners.model.InitializationError;

abstract class QualifiedTestsRunner
extends SerenityRunner {
    private String qualifier;
    private Object test;

    public QualifiedTestsRunner(Class<?> klass, String qualifier, Object test) throws InitializationError {
        super(klass);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> klass, Module module, String qualifier, Object test) throws InitializationError {
        super(klass, module);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> klass, Injector injector, String qualifier, Object test) throws InitializationError {
        super(klass, injector);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> klass, WebDriverFactory webDriverFactory, String qualifier, Object test) throws InitializationError {
        super(klass, webDriverFactory);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> klass, WebDriverFactory webDriverFactory, DriverConfiguration configuration, String qualifier, Object test) throws InitializationError {
        super(klass, webDriverFactory, configuration);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> klass, WebDriverFactory webDriverFactory, DriverConfiguration configuration, BatchManager batchManager, String qualifier, Object test) throws InitializationError {
        super(klass, webDriverFactory, configuration, batchManager);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> klass, BatchManager batchManager, String qualifier, Object test) throws InitializationError {
        super(klass, batchManager);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> klass, WebdriverManager webDriverManager, DriverConfiguration configuration, BatchManager batchManager, String qualifier, Object test) throws InitializationError {
        super(klass, webDriverManager, configuration, batchManager);
        this.qualifier = qualifier;
        this.test = test;
    }

    public QualifiedTestsRunner(Class<?> type, DriverConfiguration configuration, WebDriverFactory webDriverFactory, BatchManager batchManager) throws InitializationError {
        super(type, webDriverFactory, configuration, batchManager);
    }

    public final Object createTest() throws Exception {
        this.test = this.initializeTest();
        return this.test;
    }

    protected abstract Object initializeTest() throws Exception;

    @Override
    public final void useQualifier(String qualifier) {
        this.qualifier = qualifier;
        super.useQualifier(qualifier);
    }

    @Override
    public final List<TestOutcome> getTestOutcomes() {
        return this.enhance(this.qualified(super.getTestOutcomes()));
    }

    public List<TestOutcome> enhance(List<TestOutcome> outcomes) {
        return outcomes;
    }

    private List<TestOutcome> qualified(List<TestOutcome> testOutcomes) {
        ArrayList<TestOutcome> qualifiedOutcomes = new ArrayList<TestOutcome>();
        if (this.test != null) {
            this.useQualifier(QualifierFinder.forTestCase(this.test).getQualifier());
        }
        for (TestOutcome outcome : testOutcomes) {
            qualifiedOutcomes.add(outcome.withQualifier(this.qualifier));
        }
        return qualifiedOutcomes;
    }
}

