/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.lang.reflect.InvocationTargetException;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.model.domain.TestStep;
import org.junit.runners.model.Statement;

class SerenityStatement
extends Statement {
    private final Statement statement;
    private final StepPublisher publisher;

    SerenityStatement(Statement statement, StepPublisher publisher) {
        this.statement = statement;
        this.publisher = publisher;
    }

    StepEventBus stepEventBus() {
        if (this.publisher instanceof BaseStepListener) {
            return ((BaseStepListener)this.publisher).getEventBus();
        }
        return StepEventBus.getParallelEventBus();
    }

    public void evaluate() throws Throwable {
        block4: {
            try {
                this.updateCurrentEventBusFrom(this.publisher);
                this.statement.evaluate();
            }
            catch (AssertionError assertionError) {
                if (!this.stepEventBus().aStepInTheCurrentTestHasFailed()) {
                    throw assertionError;
                }
            }
            catch (Throwable throwable) {
                if (!throwable.getClass().getSimpleName().endsWith("AssumptionViolatedException")) break block4;
                this.stepEventBus().assumptionViolated(throwable.getMessage());
            }
        }
        this.checkForStepFailures();
        this.checkForAssumptionViolations();
    }

    private void updateCurrentEventBusFrom(StepPublisher publisher) {
        if (StepEventBus.getParallelEventBus() != this.stepEventBus()) {
            StepEventBus.overrideEventBusWith((StepEventBus)this.stepEventBus());
        }
    }

    private void checkForStepFailures() throws Throwable {
        if (this.publisher.aStepHasFailed()) {
            if (this.publisher.getTestFailureCause() != null) {
                throw this.publisher.getTestFailureCause().toException();
            }
            if (this.publisher.firstFailingStep().isPresent()) {
                throw ((TestStep)this.publisher.firstFailingStep().get()).getException().asException();
            }
        }
    }

    private void checkForAssumptionViolations() {
        if (this.stepEventBus().assumptionViolated()) {
            try {
                Class<?> assumptionViolatedException = Class.forName("org.junit.AssumptionViolatedException");
                throw (RuntimeException)assumptionViolatedException.getConstructor(String.class).newInstance(this.stepEventBus().getAssumptionViolatedMessage());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

