/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import net.serenitybdd.core.Serenity;
import net.serenitybdd.junit5.PendingTestException;
import net.serenitybdd.junit5.SkippedTestException;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.StepEventBus;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class SerenityJUnit5Extension
implements TestInstancePostProcessor,
AfterEachCallback {
    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        Serenity.injectDriverInto((Object)testInstance);
        Serenity.injectAnnotatedPagesObjectInto((Object)testInstance);
        Serenity.injectScenarioStepsInto((Object)testInstance);
        Serenity.injectDependenciesInto((Object)testInstance);
    }

    public void afterEach(ExtensionContext context) {
        if (!StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            System.out.println("NO BASE STEP LISTENER FOUND IN THREAD " + Thread.currentThread());
        }
        TestOutcome outcome = StepEventBus.getEventBus().getBaseStepListener().getCurrentTestOutcome();
        String methodName = outcome.getQualifiedMethodName();
        context.getTestMethod().ifPresent(method -> {
            if (method.getName().equals(methodName)) {
                if (outcome.getTestFailureCause() != null) {
                    throw outcome.getTestFailureCause().asRuntimeException();
                }
                if (outcome.isPending().booleanValue()) {
                    throw new PendingTestException(context.getDisplayName());
                }
                if (outcome.isSkipped().booleanValue()) {
                    throw new SkippedTestException(context.getDisplayName());
                }
            }
        });
    }
}

