/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.serenitybdd.junit5.AssertThrowsAdvice;
import net.serenitybdd.junit5.JUnit5DataDrivenAnnotations;
import net.serenitybdd.junit5.JUnit5TestMethodAnnotations;
import net.serenitybdd.junit5.ParameterizedTestsOutcomeAggregator;
import net.serenitybdd.junit5.SerenityJUnit5Extension;
import net.serenitybdd.junit5.SerenityTestExecutionSummary;
import net.serenitybdd.junit5.TestMethodConfiguration;
import net.thucydides.core.configuration.SystemPropertiesConfiguration;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestSourceType;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.SystemEnvironmentVariables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class SerenityTestExecutionListener
implements TestExecutionListener {
    private static List<Class> expectedExceptions = Collections.synchronizedList(new ArrayList());
    private final Logger logger = LoggerFactory.getLogger(SerenityTestExecutionListener.class);
    private ReportService reportService;
    private SerenityTestExecutionSummary summary;
    private Pages pages;
    private Map<String, DataTable> dataTables = new HashMap<String, DataTable>();
    private int parameterSetNumber = 0;
    private BaseStepListener baseStepListener;
    private Class<?> testClass;
    private boolean isDataDrivenTest = false;
    private boolean isSerenityTest = false;

    public SerenityTestExecutionListener() {
        File outputDirectory = this.getOutputDirectory();
        this.baseStepListener = Listeners.getBaseStepListener().withOutputDirectory(outputDirectory);
        StepEventBus.getEventBus().registerListener((StepListener)this.baseStepListener);
    }

    private File getOutputDirectory() {
        SystemPropertiesConfiguration systemPropertiesConfiguration = new SystemPropertiesConfiguration((EnvironmentVariables)new SystemEnvironmentVariables());
        return systemPropertiesConfiguration.getOutputDirectory();
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.summary = new SerenityTestExecutionSummary(testPlan);
        testPlan.getRoots().forEach(root -> {
            Set children = testPlan.getChildren(root.getUniqueId());
            children.stream().filter(this::isClassSource).filter(this::isASerenityTest).forEach(this::configureParameterizedTestDataFor);
        });
    }

    private boolean isASerenityTest(TestIdentifier child) {
        return SerenityTestExecutionListener.isSerenityTestClass(((ClassSource)child.getSource().get()).getJavaClass());
    }

    private void configureParameterizedTestDataFor(TestIdentifier serenityTest) {
        Class javaClass = ((ClassSource)serenityTest.getSource().get()).getJavaClass();
        Map<String, DataTable> parameterTablesForClass = JUnit5DataDrivenAnnotations.forClass(javaClass).getParameterTables();
        if (!parameterTablesForClass.isEmpty()) {
            this.dataTables.putAll(parameterTablesForClass);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (!this.isSerenityTest) {
            return;
        }
        this.logger.debug("->TestPlanExecutionFinished " + testPlan);
    }

    private void generateReportsForTest() {
        if (this.isDataDrivenTest) {
            this.generateReportsForParameterizedTest();
            this.isDataDrivenTest = false;
        } else {
            this.generateReports();
        }
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (!this.isSerenityTest) {
            return;
        }
        this.processTestMethodAnnotationsFor(testIdentifier);
    }

    private void processTestMethodAnnotationsFor(TestIdentifier testIdentifier) {
        Optional testSource = testIdentifier.getSource();
        if (testSource.isPresent() && testSource.get() instanceof MethodSource) {
            MethodSource methodTestSource = (MethodSource)testIdentifier.getSource().get();
            String className = methodTestSource.getClassName();
            String methodName = methodTestSource.getMethodName();
            String methodParameterTypes = methodTestSource.getMethodParameterTypes();
            List methodParameterClasses = null;
            if (methodParameterTypes != null) {
                methodParameterClasses = Arrays.asList(methodParameterTypes.split(",")).stream().map(parameterClassName -> {
                    try {
                        return ClassUtils.forName((String)parameterClassName.trim(), (ClassLoader)this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.error("Problem when getting parameter classes ", (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
            }
            try {
                if (this.isIgnored(this.getProcessedMethod(className, methodName, methodParameterClasses))) {
                    this.startTestAtEventBus(testIdentifier);
                    StepEventBus.getEventBus().testIgnored();
                    StepEventBus.getEventBus().testFinished();
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException exception) {
                this.logger.error("Exception when processing method annotations", (Throwable)exception);
            }
        }
    }

    private Method getProcessedMethod(String className, String methodName, List<Class> methodParameterClasses) throws NoSuchMethodException, ClassNotFoundException {
        if (methodParameterClasses != null) {
            Class[] classesArray = new Class[methodParameterClasses.size()];
            return Class.forName(className).getMethod(methodName, methodParameterClasses.toArray(classesArray));
        }
        return Class.forName(className).getMethod(methodName, new Class[0]);
    }

    private boolean isIgnored(Method child) {
        return child.getAnnotation(Disabled.class) != null;
    }

    private void startTestAtEventBus(TestIdentifier testIdentifier) {
        StepEventBus.getEventBus().setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
        String displayName = this.removeEndBracketsFromDisplayName(testIdentifier.getDisplayName());
        if (this.isMethodSource(testIdentifier)) {
            String className = ((MethodSource)testIdentifier.getSource().get()).getClassName();
            try {
                StepEventBus.getEventBus().testStarted(Optional.ofNullable(displayName).orElse("Initialisation"), Class.forName(className));
            }
            catch (ClassNotFoundException exception) {
                this.logger.error("Exception when starting test at event bus ", (Throwable)exception);
            }
        }
    }

    private String removeEndBracketsFromDisplayName(String displayName) {
        if (displayName != null && displayName.endsWith("()")) {
            displayName = displayName.substring(0, displayName.length() - 2);
        }
        return displayName;
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (!testIdentifier.getSource().isPresent()) {
            this.logger.trace("No action done at executionStarted because testIdentifier is null");
            return;
        }
        if (this.isTestContainer(testIdentifier) && this.isClassSource(testIdentifier)) {
            this.testClass = ((ClassSource)testIdentifier.getSource().get()).getJavaClass();
            this.isSerenityTest = SerenityTestExecutionListener.isSerenityTestClass(this.testClass);
            if (!this.isSerenityTest) {
                this.logger.trace("-->Execution started but no SerenityClass " + this.testClass);
                return;
            }
            this.logger.trace("-->Execution started " + testIdentifier.getDisplayName() + "--" + testIdentifier.getType() + "--" + testIdentifier.getSource());
            this.logger.trace("-->TestSuiteStarted " + this.testClass);
            this.baseStepListener.clearTestOutcomes();
            StepEventBus.getEventBus().testSuiteStarted(this.testClass);
        }
        if (this.isMethodSource(testIdentifier)) {
            String sourceMethod;
            DataTable dataTable;
            MethodSource methodSource = (MethodSource)testIdentifier.getSource().get();
            if (this.isSimpleTest(testIdentifier)) {
                this.testStarted(methodSource, testIdentifier);
            }
            if ((dataTable = this.dataTables.get(sourceMethod = methodSource.getClassName() + "." + methodSource.getMethodName())) != null) {
                this.logger.trace("FoundDataTable " + dataTable + " " + dataTable.getRows());
                this.isDataDrivenTest = true;
                if (this.isTestContainer(testIdentifier)) {
                    this.parameterSetNumber = 0;
                } else if (this.isSimpleTest(testIdentifier)) {
                    StepEventBus.getEventBus().useExamplesFrom(dataTable);
                    this.logger.trace("-->EventBus.useExamplesFrom" + dataTable);
                    this.logger.trace("-->EventBus.exampleStarted " + this.parameterSetNumber + "--" + dataTable.row(this.parameterSetNumber).toStringMap());
                    StepEventBus.getEventBus().exampleStarted(dataTable.row(this.parameterSetNumber).toStringMap());
                }
            }
        }
    }

    private boolean isTestContainer(TestIdentifier testIdentifier) {
        return TestDescriptor.Type.CONTAINER == testIdentifier.getType();
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!this.isSerenityTest) {
            return;
        }
        this.logger.trace("-->Execution finished " + testIdentifier.getDisplayName() + "--" + testIdentifier.getType() + "--" + testIdentifier.getSource() + " with result " + testExecutionResult.getStatus());
        if (!testIdentifier.getSource().isPresent()) {
            this.logger.info("No action done at executionFinished because testIdentifier is null");
            return;
        }
        if (this.isTestContainer(testIdentifier) && this.isClassSource(testIdentifier)) {
            this.logger.trace("-->EventBus.TestSuiteFinished " + ((ClassSource)testIdentifier.getSource().get()).getJavaClass());
            StepEventBus.getEventBus().testSuiteFinished();
            this.generateReportsForTest();
        }
        if (this.isSimpleTest(testIdentifier) && this.isMethodSource(testIdentifier)) {
            MethodSource methodSource = (MethodSource)testIdentifier.getSource().get();
            String sourceMethod = methodSource.getClassName() + "." + methodSource.getMethodName();
            this.testFinished(testIdentifier, methodSource, testExecutionResult);
            DataTable dataTable = this.dataTables.get(sourceMethod);
            if (dataTable != null) {
                this.logger.trace("-->EventBus.exampleFinished " + this.parameterSetNumber + "--" + dataTable.row(this.parameterSetNumber).toStringMap());
                StepEventBus.getEventBus().exampleFinished();
                ++this.parameterSetNumber;
            }
        }
        this.recordSummaryData(testIdentifier, testExecutionResult);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recordSummaryData(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        try {
            switch (testExecutionResult.getStatus()) {
                case SUCCESSFUL: {
                    if (testIdentifier.isContainer()) {
                        this.summary.containersSucceeded.incrementAndGet();
                    }
                    if (!testIdentifier.isTest()) return;
                    this.summary.testsSucceeded.incrementAndGet();
                    return;
                }
                case ABORTED: {
                    if (testIdentifier.isContainer()) {
                        this.summary.containersAborted.incrementAndGet();
                    }
                    if (!testIdentifier.isTest()) return;
                    this.summary.testsAborted.incrementAndGet();
                    return;
                }
                case FAILED: {
                    if (testIdentifier.isContainer()) {
                        this.summary.containersFailed.incrementAndGet();
                    }
                    if (testIdentifier.isTest()) {
                        this.summary.testsFailed.incrementAndGet();
                    }
                    testExecutionResult.getThrowable().ifPresent(throwable -> this.summary.addFailure(testIdentifier, (Throwable)throwable));
                    StepEventBus.getEventBus().testFailed((Throwable)testExecutionResult.getThrowable().get());
                    return;
                }
                default: {
                    throw new PreconditionViolationException("Unsupported execution status:" + testExecutionResult.getStatus());
                }
            }
        }
        finally {
            expectedExceptions.clear();
        }
    }

    private void testFinished(TestIdentifier testIdentifier, MethodSource methodSource, TestExecutionResult testExecutionResult) {
        this.updateResultsUsingTestAnnotations(methodSource);
        TestResult result = StepEventBus.getEventBus().getBaseStepListener().getCurrentTestOutcome().getResult();
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED && result == TestResult.SUCCESS) {
            this.updateResultsUsingTestExecutionResult(testExecutionResult);
        } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED && result.isLessSevereThan(TestResult.FAILURE)) {
            this.updateResultsUsingTestExecutionResult(testExecutionResult);
        }
        StepEventBus.getEventBus().testFinished();
        StepEventBus.getEventBus().setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
    }

    private void updateResultsUsingTestExecutionResult(TestExecutionResult testExecutionResult) {
        testExecutionResult.getThrowable().ifPresent(cause -> StepEventBus.getEventBus().getBaseStepListener().updateCurrentStepFailureCause(cause));
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            StepEventBus.getEventBus().getBaseStepListener().overrideResultTo(TestResult.ABORTED);
        }
    }

    private void updateResultsUsingTestAnnotations(MethodSource methodSource) {
        if (TestMethodConfiguration.forMethod(methodSource.getJavaMethod()).isManual()) {
            this.setToManual(methodSource);
        }
        expectedExceptions.stream().forEach(this::updateResultsForExpectedException);
    }

    private void setToManual(MethodSource methodSource) {
        StepEventBus.getEventBus().testIsManual();
        TestResult result = TestMethodConfiguration.forMethod(methodSource.getJavaMethod()).getManualResult();
        StepEventBus.getEventBus().getBaseStepListener().recordManualTestResult(result);
    }

    private void updateResultsForExpectedException(Class<? extends Throwable> expected) {
        StepEventBus.getEventBus().exceptionExpected(expected);
    }

    private boolean isSimpleTest(TestIdentifier testIdentifier) {
        return testIdentifier.getType() == TestDescriptor.Type.TEST;
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        if (!this.isSerenityTest) {
            return;
        }
        this.logger.trace("-->ReportingEntryPublished " + testIdentifier.getDisplayName() + "--" + testIdentifier.getType() + "--" + testIdentifier.getSource());
    }

    private boolean isClassSource(TestIdentifier testId) {
        return testId.getSource().isPresent() && testId.getSource().get() instanceof ClassSource;
    }

    private boolean isMethodSource(TestIdentifier testId) {
        return testId.getSource().isPresent() && testId.getSource().get() instanceof MethodSource;
    }

    private void testStarted(MethodSource methodSource, TestIdentifier testIdentifier) {
        if (this.testingThisTest(testIdentifier)) {
            this.startTestSuiteForFirstTest(testIdentifier);
            this.logger.debug(Thread.currentThread() + " Test started " + testIdentifier);
            StepEventBus.getEventBus().clear();
            StepEventBus.getEventBus().setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
            String testName = methodSource.getMethodName();
            try {
                Method javaMethod = methodSource.getJavaMethod();
                if (JUnit5TestMethodAnnotations.forTest(javaMethod).getDisplayName().isPresent()) {
                    testName = JUnit5TestMethodAnnotations.forTest(javaMethod).getDisplayName().get();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            StepEventBus.getEventBus().testStarted(Optional.ofNullable(testName).orElse("Initialisation"), methodSource.getJavaClass());
            if (this.isPending(methodSource)) {
                StepEventBus.getEventBus().testPending();
            }
        }
    }

    private boolean isPending(MethodSource methodSource) {
        try {
            return TestMethodConfiguration.forMethod(methodSource.getJavaMethod()).isPending();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean testingThisTest(TestIdentifier testIdentifier) {
        MethodSource methodSource;
        return this.isMethodSource(testIdentifier) && this.testClass.equals((methodSource = (MethodSource)testIdentifier.getSource().get()).getJavaClass());
    }

    private void startTestSuiteForFirstTest(TestIdentifier testIdentifier) {
        if (this.isMethodSource(testIdentifier)) {
            this.logger.trace("-->TestSuiteStarted " + ((MethodSource)testIdentifier.getSource().get()).getJavaClass());
            StepEventBus.getEventBus().testSuiteStarted(((MethodSource)testIdentifier.getSource().get()).getJavaClass());
        }
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.baseStepListener.getTestOutcomes();
    }

    private void generateReports() {
        this.generateReportsFor(this.getTestOutcomes());
    }

    private void generateReportsForParameterizedTest() {
        ParameterizedTestsOutcomeAggregator parameterizedTestsOutcomeAggregator = new ParameterizedTestsOutcomeAggregator();
        this.generateReportsFor(parameterizedTestsOutcomeAggregator.aggregateTestOutcomesByTestMethods());
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
        this.getReportService().generateConfigurationsReport();
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), (Collection)ReportService.getDefaultReporters());
        }
        return this.reportService;
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injector().injectAnnotatedPagesObjectInto(testCase, this.pages);
    }

    public static void addExpectedException(Class exceptionClass) {
        expectedExceptions.add(exceptionClass);
    }

    static boolean isSerenityTestClass(Class<?> testClass) {
        return SerenityTestExecutionListener.classNestStructure(testClass).stream().filter(clazz -> clazz.getAnnotation(ExtendWith.class) != null).map(clazz -> clazz.getAnnotation(ExtendWith.class)).anyMatch(annotation -> Arrays.asList(annotation.value()).contains(SerenityJUnit5Extension.class));
    }

    private static List<Class<?>> classNestStructure(Class<?> testClass) {
        ArrayList nestedStructure = new ArrayList();
        nestedStructure.add(testClass);
        for (Class<?> declaringClass = testClass.getDeclaringClass(); declaringClass != null; declaringClass = declaringClass.getDeclaringClass()) {
            nestedStructure.add(declaringClass);
        }
        return nestedStructure;
    }

    static {
        ByteBuddyAgent.install();
        new ByteBuddy().rebase(Assertions.class).visit((AsmVisitorWrapper)Advice.to(AssertThrowsAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"assertThrows"))).make().load(Assertions.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }
}

