/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Optional;
import net.thucydides.core.annotations.DriverOptions;
import net.thucydides.core.annotations.WithDriver;
import org.junit.jupiter.api.DisplayName;

public class JUnit5TestMethodAnnotations {
    private final Method method;

    private JUnit5TestMethodAnnotations(Method method) {
        this.method = method;
    }

    public static JUnit5TestMethodAnnotations forTest(Method method) {
        return new JUnit5TestMethodAnnotations(method);
    }

    public boolean isDriverSpecified() {
        return this.method.getAnnotation(WithDriver.class) != null;
    }

    public Optional<String> getDisplayName() {
        DisplayName displayNameAnnotation = this.method.getAnnotation(DisplayName.class);
        if (displayNameAnnotation != null) {
            return Optional.of(displayNameAnnotation.value());
        }
        return Optional.empty();
    }

    public String specifiedDriver() {
        Preconditions.checkArgument((boolean)this.isDriverSpecified());
        return this.method.getAnnotation(WithDriver.class).value();
    }

    public String driverOptions() {
        Preconditions.checkArgument((boolean)this.isDriverSpecified());
        return this.method.getAnnotation(DriverOptions.class).value();
    }
}

