/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.lang.reflect.Method;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.annotations.environment.AnnotatedEnvironmentProperties;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.junit5.JUnit5Tags;
import net.serenitybdd.junit5.PendingTestException;
import net.serenitybdd.junit5.SkippedTestException;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestSourceType;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityJUnit5Extension
implements TestInstancePostProcessor,
AfterEachCallback,
BeforeEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityJUnit5Extension.class);

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        Serenity.injectDriverInto((Object)testInstance);
        Serenity.injectAnnotatedPagesObjectInto((Object)testInstance);
        Serenity.injectScenarioStepsInto((Object)testInstance);
        Serenity.injectDependenciesInto((Object)testInstance);
        SystemEnvironmentVariables.currentEnvironmentVariables().reset();
    }

    private StepEventBus eventBusFor(ExtensionContext context) {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            StepEventBus eventBus = StepEventBus.eventBusFor((Object)context.getUniqueId());
            if (!eventBus.isBaseStepListenerRegistered()) {
                eventBus.registerListener((StepListener)new BaseStepListener(ConfiguredEnvironment.getConfiguration().getOutputDirectory()));
            }
            StepEventBus.setCurrentBusToEventBusFor((Object)context.getTestMethod());
        }
        return StepEventBus.getParallelEventBus();
    }

    public void beforeEach(ExtensionContext context) {
        context.getTestMethod().ifPresent(method -> {
            AnnotatedEnvironmentProperties.apply((Method)method);
            if (!this.eventBusFor(context).isBaseStepListenerRegistered()) {
                this.eventBusFor(context).registerListener((StepListener)new BaseStepListener(ConfiguredEnvironment.getConfiguration().getOutputDirectory()));
            }
            this.eventBusFor(context).getBaseStepListener().addTagsToCurrentStory(JUnit5Tags.forMethod(method));
            this.eventBusFor(context).setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
        });
    }

    public void afterEach(ExtensionContext context) {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            LOGGER.warn("NO BASE STEP LISTENER FOUND IN THREAD " + Thread.currentThread());
        }
        TestOutcome outcome = StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome();
        String methodName = outcome.getQualifiedMethodName();
        context.getTestMethod().ifPresent(method -> {
            if (method.getName().equals(methodName)) {
                if (outcome.getTestFailureCause() != null) {
                    throw outcome.getTestFailureCause().asRuntimeException();
                }
                if (outcome.isPending().booleanValue()) {
                    throw new PendingTestException(context.getDisplayName());
                }
                if (outcome.isSkipped().booleanValue()) {
                    throw new SkippedTestException(context.getDisplayName());
                }
            }
        });
    }
}

