/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.lang.reflect.Method;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.annotations.environment.AnnotatedEnvironmentProperties;
import net.serenitybdd.junit5.JUnit5Tags;
import net.serenitybdd.junit5.PendingTestException;
import net.serenitybdd.junit5.SkippedTestException;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.logging.ConsoleLoggingListener;
import net.thucydides.model.steps.StepListener;
import net.thucydides.model.steps.TestSourceType;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityJUnit5Extension
implements TestInstancePostProcessor,
AfterEachCallback,
BeforeEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityJUnit5Extension.class);

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        Serenity.injectDriverInto((Object)testInstance);
        Serenity.injectAnnotatedPagesObjectInto((Object)testInstance);
        Serenity.injectScenarioStepsInto((Object)testInstance);
        Serenity.injectDependenciesInto((Object)testInstance);
        SystemEnvironmentVariables.currentEnvironment().reset();
    }

    private StepEventBus eventBusFor(ExtensionContext context) {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            StepEventBus eventBus = StepEventBus.eventBusFor((Object)context.getUniqueId());
            if (!eventBus.isBaseStepListenerRegistered()) {
                eventBus.registerListener((StepListener)new BaseStepListener(ConfiguredEnvironment.getConfiguration().getOutputDirectory()));
                eventBus.registerListener((StepListener)new ConsoleLoggingListener(ConfiguredEnvironment.getEnvironmentVariables()));
            }
            StepEventBus.setCurrentBusToEventBusFor((Object)context.getTestMethod());
        }
        return StepEventBus.getParallelEventBus();
    }

    public void beforeEach(ExtensionContext context) {
        context.getTestMethod().ifPresent(method -> {
            AnnotatedEnvironmentProperties.apply((Method)method);
            if (!this.eventBusFor(context).isBaseStepListenerRegistered()) {
                this.eventBusFor(context).registerListener((StepListener)new BaseStepListener(ConfiguredEnvironment.getConfiguration().getOutputDirectory()));
                this.eventBusFor(context).registerListener((StepListener)new ConsoleLoggingListener(ConfiguredEnvironment.getEnvironmentVariables()));
            }
            this.eventBusFor(context).getBaseStepListener().addTagsToCurrentStory(JUnit5Tags.forMethod(method));
            this.eventBusFor(context).setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
        });
    }

    public void afterEach(ExtensionContext context) {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            LOGGER.warn("NO BASE STEP LISTENER FOUND IN THREAD " + String.valueOf(Thread.currentThread()));
        }
        TestOutcome outcome = StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome();
        String methodName = outcome.getQualifiedMethodName();
        String displayName = context.getDisplayName();
        context.getTestMethod().ifPresent(method -> {
            if (methodName != null && (methodName.equals(method.getName()) || methodName.equals(displayName))) {
                if (outcome.getTestFailureCause() != null) {
                    throw outcome.getTestFailureCause().asRuntimeException();
                }
                if (outcome.isPending().booleanValue()) {
                    throw new PendingTestException(context.getDisplayName());
                }
                if (outcome.isSkipped().booleanValue()) {
                    throw new SkippedTestException(context.getDisplayName());
                }
            }
        });
    }
}

