/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.junit5.datadriven.JUnit5CSVTestDataSource;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit5DataDrivenAnnotations {
    private final Logger logger = LoggerFactory.getLogger(JUnit5DataDrivenAnnotations.class);
    private final EnvironmentVariables environmentVariables;
    private final Class testClass;
    private final Map<String, DataTable> parameterTables;

    public static JUnit5DataDrivenAnnotations forClass(Class testClass) {
        return new JUnit5DataDrivenAnnotations(testClass);
    }

    JUnit5DataDrivenAnnotations(Class testClass) {
        this(testClass, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    JUnit5DataDrivenAnnotations(Class testClass, EnvironmentVariables environmentVariables) {
        this.testClass = testClass;
        this.environmentVariables = environmentVariables;
        this.parameterTables = this.generateParameterTables();
    }

    public Map<String, DataTable> getParameterTables() {
        return this.parameterTables;
    }

    private Map<String, DataTable> generateParameterTables() {
        List<Method> allMethods = this.findTestDataMethods();
        HashMap<String, DataTable> dataTables = new HashMap<String, DataTable>();
        for (Method testDataMethod : allMethods) {
            if (this.isAValueSourceAnnotatedMethod(testDataMethod)) {
                this.fillDataTablesFromValueSource(dataTables, testDataMethod);
                continue;
            }
            if (this.isACsvFileSourceAnnotatedMethod(testDataMethod)) {
                this.fillDataTablesFromCsvFileSource(dataTables, testDataMethod);
                continue;
            }
            if (this.isAEnumSourceAnnotatedMethod(testDataMethod)) {
                this.fillDataTablesFromEnumSource(dataTables, testDataMethod);
                continue;
            }
            if (this.isACsvSourceAnnotatedMethod(testDataMethod)) {
                this.fillDataTablesFromCsvSource(dataTables, testDataMethod);
                continue;
            }
            if (this.isAMethodSourceAnnotatedMethod(testDataMethod)) {
                this.fillDataTablesFromMethodSource(dataTables, testDataMethod);
                continue;
            }
            if (!this.isAnArgumentsSourceAnnotatedMethod(testDataMethod)) continue;
            this.fillDataTablesFromArgumentsSource(dataTables, testDataMethod);
        }
        return dataTables;
    }

    private void fillDataTablesFromEnumSource(Map<String, DataTable> dataTables, Method testDataMethod) {
        String columnNamesString = this.createColumnNamesFromParameterNames(testDataMethod);
        String dataTableName = testDataMethod.getDeclaringClass().getCanonicalName() + "." + testDataMethod.getName();
        List<List<Object>> parametersAsListsOfObjects = this.listOfEnumSourceObjectsFrom(testDataMethod);
        this.logger.debug("GetParameterTablesEnumSource: Put parameter dataTableName " + dataTableName + " -- " + String.valueOf(parametersAsListsOfObjects));
        dataTables.put(dataTableName, this.createParametersTableFrom(columnNamesString, parametersAsListsOfObjects));
    }

    private void fillDataTablesFromValueSource(Map<String, DataTable> dataTables, Method testDataMethod) {
        String columnNamesString = this.createColumnNamesFromParameterNames(testDataMethod);
        String dataTableName = testDataMethod.getDeclaringClass().getCanonicalName() + "." + testDataMethod.getName();
        List<List<Object>> parametersAsListsOfObjects = this.listOfObjectsFromValueSource(testDataMethod);
        this.logger.debug("GetParameterTables: Put parameter dataTableName " + dataTableName + " -- " + String.valueOf(parametersAsListsOfObjects));
        dataTables.put(dataTableName, this.createParametersTableFrom(columnNamesString, parametersAsListsOfObjects));
    }

    private void fillDataTablesFromCsvSource(Map<String, DataTable> dataTables, Method testDataMethod) {
        CsvSource csvSource = testDataMethod.getAnnotation(CsvSource.class);
        if (csvSource.textBlock() != null && !csvSource.textBlock().isEmpty()) {
            this.fillDataTablesFromCsvSourceTextBlock(dataTables, testDataMethod);
        } else {
            this.fillDataTablesFromCsvSourceValues(dataTables, testDataMethod);
        }
    }

    private void fillDataTablesFromCsvSourceTextBlock(Map<String, DataTable> dataTables, Method testDataMethod) {
        CsvSource csvSource = testDataMethod.getAnnotation(CsvSource.class);
        String deliminator = ",";
        if (csvSource.delimiterString() != null) {
            deliminator = csvSource.delimiterString();
        } else if (csvSource.delimiter() != '\u0000') {
            deliminator = String.valueOf(csvSource.delimiter());
        }
        String columnNamesString = this.createColumnNamesFromParameterNames(testDataMethod);
        String dataTableName = testDataMethod.getDeclaringClass().getCanonicalName() + "." + testDataMethod.getName();
        String testData = csvSource.textBlock();
        List<List<Object>> rows = this.listOfCsvObjectsFrom(testData.split("\\R"), deliminator);
        this.logger.debug("GetParameterTables: Put parameter dataTableName " + dataTableName + " -- " + String.valueOf(rows));
        dataTables.put(dataTableName, this.createParametersTableFrom(columnNamesString, rows));
    }

    private void fillDataTablesFromCsvSourceValues(Map<String, DataTable> dataTables, Method testDataMethod) {
        String columnNamesString = this.createColumnNamesFromParameterNames(testDataMethod);
        String dataTableName = testDataMethod.getDeclaringClass().getCanonicalName() + "." + testDataMethod.getName();
        List<List<Object>> parametersAsListsOfObjects = this.listOfCsvObjectsFrom(testDataMethod);
        this.logger.debug("GetParameterTables: Put parameter dataTableName " + dataTableName + " -- " + String.valueOf(parametersAsListsOfObjects));
        dataTables.put(dataTableName, this.createParametersTableFrom(columnNamesString, parametersAsListsOfObjects));
    }

    private void fillDataTablesFromCsvFileSource(Map<String, DataTable> dataTables, Method testDataMethod) {
        CsvFileSource annotation = testDataMethod.getAnnotation(CsvFileSource.class);
        String[] paths = annotation.resources().length == 0 ? annotation.files() : annotation.resources();
        String columnNamesString = this.createColumnNamesFromParameterNames(testDataMethod);
        String dataTableName = testDataMethod.getDeclaringClass().getCanonicalName() + "." + testDataMethod.getName();
        try {
            JUnit5CSVTestDataSource csvTestDataSource = new JUnit5CSVTestDataSource(Arrays.asList(paths), ',');
            List<Map<String, String>> data = csvTestDataSource.getData();
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            for (Map<String, String> dataRowMap : data) {
                ArrayList<String> dataRow = new ArrayList<String>();
                for (String header : csvTestDataSource.getHeaders()) {
                    dataRow.add(dataRowMap.get(header));
                }
                rows.add(dataRow);
            }
            this.logger.debug("GetParameterTablesCSV: Put parameter dataTableName " + dataTableName);
            dataTables.put(dataTableName, this.createParametersTableFrom(columnNamesString, rows));
        }
        catch (IOException e) {
            this.logger.error("Cannot load csv resource ", (Throwable)e);
        }
    }

    private void fillDataTablesFromMethodSource(Map<String, DataTable> dataTables, Method testDataMethod) {
        String columnNamesString = this.createColumnNamesFromParameterNames(testDataMethod);
        String dataTableName = testDataMethod.getDeclaringClass().getCanonicalName() + "." + testDataMethod.getName();
        List<List<Object>> parametersAsListsOfObjects = this.listOfObjectsFromMethodSource(testDataMethod);
        this.logger.info("GetParameterTablesFromMethodSource: Put parameter dataTableName " + dataTableName + " " + String.valueOf(parametersAsListsOfObjects));
        dataTables.put(dataTableName, this.createParametersTableFrom(columnNamesString, parametersAsListsOfObjects));
    }

    private void fillDataTablesFromArgumentsSource(Map<String, DataTable> dataTables, Method testDataMethod) {
        String columnNamesString = this.createColumnNamesFromParameterNames(testDataMethod);
        String dataTableName = testDataMethod.getDeclaringClass().getCanonicalName() + "." + testDataMethod.getName();
        List<List<Object>> parametersAsListsOfObjects = this.listOfObjectsFromMethodSource(testDataMethod);
        this.logger.info("GetParameterTablesFromMethodSource: Put parameter dataTableName " + dataTableName + " " + String.valueOf(parametersAsListsOfObjects));
        dataTables.put(dataTableName, this.createParametersTableFrom(columnNamesString, parametersAsListsOfObjects));
    }

    List<Method> findTestDataMethods() {
        return this.findTestDataMethods(this.testClass);
    }

    List<Method> findTestDataMethods(Class<?> testClass) {
        ArrayList<Method> dataDrivenMethods = new ArrayList<Method>();
        List<Method> allMethods = Arrays.asList(testClass.getDeclaredMethods());
        allMethods.stream().filter(this::findParameterizedTests).forEach(dataDrivenMethods::add);
        List<Class<?>> nestedClasses = Arrays.asList(testClass.getDeclaredClasses());
        nestedClasses.forEach(nestedClass -> dataDrivenMethods.addAll(this.findTestDataMethods((Class<?>)nestedClass)));
        return dataDrivenMethods;
    }

    String createColumnNamesFromParameterNames(Method method) {
        return Arrays.asList(method.getParameters()).stream().map(Parameter::getName).collect(Collectors.joining(","));
    }

    List<List<Object>> listOfObjectsFromMethodSource(Method testDataMethod) {
        Object result;
        String methodName;
        MethodSource methodSourceAnnotation = testDataMethod.getAnnotation(MethodSource.class);
        String[] value = methodSourceAnnotation.value();
        boolean staticMethodUsed = this.isStaticMethodUsed(testDataMethod);
        if (value != null && value.length > 0 && !value[0].isEmpty()) {
            List<String> methodNames = Arrays.asList(value);
            methodName = methodNames.get(0);
            if (methodName.indexOf("#") > 0 && (result = this.getListOfObjectsFromExternalClassSource(methodName)) != null) {
                return result;
            }
        } else {
            methodName = testDataMethod.getName();
        }
        try {
            Method factoryMethod = testDataMethod.getDeclaringClass().getDeclaredMethod(methodName, new Class[0]);
            factoryMethod.setAccessible(true);
            try {
                result = null;
                result = staticMethodUsed ? (Stream)factoryMethod.invoke(null, new Object[0]) : (Stream)factoryMethod.invoke(testDataMethod.getDeclaringClass().getConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                return result.map(argument -> this.convertToListOfParameters(argument)).collect(Collectors.toList());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.logger.error("Cannot get list of objects from method source ", (Throwable)e);
            }
        }
        catch (NoSuchMethodException ex) {
            this.logger.error("No static method with the name " + methodName + " found ", (Throwable)ex);
        }
        return null;
    }

    private List<Object> convertToListOfParameters(Object argument) {
        if (argument instanceof Arguments) {
            return Arrays.asList(((Arguments)argument).get());
        }
        return Collections.singletonList(argument);
    }

    private boolean isStaticMethodUsed(Method testDataMethod) {
        List<Annotation> annotations = Arrays.asList(testDataMethod.getDeclaringClass().getDeclaredAnnotations());
        List allTestInstanceAnnotations = annotations.stream().filter(annotation -> annotation.annotationType().equals(TestInstance.class)).collect(Collectors.toList());
        Optional<Annotation> perClassAnnotation = allTestInstanceAnnotations.stream().filter(currentAnnotation -> ((TestInstance)currentAnnotation).value().equals((Object)TestInstance.Lifecycle.PER_CLASS)).findAny();
        return !perClassAnnotation.isPresent();
    }

    private List<List<Object>> getListOfObjectsFromExternalClassSource(String methodName) {
        String externalParameterFactoryClassName = methodName.substring(0, methodName.indexOf("#"));
        String externalParameterFactoryMethodName = methodName.substring(methodName.indexOf("#") + 1);
        try {
            Class<?> externalClassFactory = Class.forName(externalParameterFactoryClassName);
            Method factoryMethod = externalClassFactory.getDeclaredMethod(externalParameterFactoryMethodName, new Class[0]);
            factoryMethod.setAccessible(true);
            Stream result = (Stream)factoryMethod.invoke(null, new Object[0]);
            return result.map(argument -> Arrays.asList(argument.get())).collect(Collectors.toList());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error("Cannot found external parameter factory class method", (Throwable)e);
            return null;
        }
    }

    List<List<Object>> listOfObjectsFromValueSource(Method testDataMethod) {
        ValueSource annotation = testDataMethod.getAnnotation(ValueSource.class);
        if (ArrayUtils.isNotEmpty((Object[])annotation.strings())) {
            return this.listOfObjectsFrom(annotation.strings());
        }
        if (ArrayUtils.isNotEmpty((byte[])annotation.bytes())) {
            return this.listOfObjectsFrom(ArrayUtils.toObject((byte[])annotation.bytes()));
        }
        if (ArrayUtils.isNotEmpty((char[])annotation.chars())) {
            return this.listOfObjectsFrom(ArrayUtils.toObject((char[])annotation.chars()));
        }
        if (ArrayUtils.isNotEmpty((double[])annotation.doubles())) {
            return this.listOfObjectsFrom(ArrayUtils.toObject((double[])annotation.doubles()));
        }
        if (ArrayUtils.isNotEmpty((float[])annotation.floats())) {
            return this.listOfObjectsFrom(ArrayUtils.toObject((float[])annotation.floats()));
        }
        if (ArrayUtils.isNotEmpty((int[])annotation.ints())) {
            return this.listOfObjectsFrom(ArrayUtils.toObject((int[])annotation.ints()));
        }
        if (ArrayUtils.isNotEmpty((short[])annotation.shorts())) {
            return this.listOfObjectsFrom(ArrayUtils.toObject((short[])annotation.shorts()));
        }
        if (ArrayUtils.isNotEmpty((Object[])annotation.classes())) {
            return this.listOfObjectsFrom(annotation.classes());
        }
        return null;
    }

    List<List<Object>> listOfCsvObjectsFrom(Method testDataMethod) {
        CsvSource annotation = testDataMethod.getAnnotation(CsvSource.class);
        String annotationDelimiter = annotation.delimiterString();
        String delimiter = annotationDelimiter != null && !annotationDelimiter.isEmpty() ? annotationDelimiter : ",";
        return this.listOfCsvObjectsFrom(annotation.value(), delimiter);
    }

    private List<List<Object>> listOfCsvObjectsFrom(Object[] parameters, String delimiter) {
        ArrayList<List<Object>> ret = new ArrayList<List<Object>>();
        for (Object parameter : parameters) {
            String[] split = ((String)parameter).split(Pattern.quote(delimiter));
            ret.add(Arrays.asList(split));
        }
        return ret;
    }

    List<List<Object>> listOfEnumSourceObjectsFrom(Method testDataMethod) {
        EnumSource annotation = testDataMethod.getAnnotation(EnumSource.class);
        Class enumValue = annotation.value();
        if (annotation.value() != null) {
            Object[] enumConstants = (Enum[])enumValue.getEnumConstants();
            EnumSource.Mode mode = annotation.mode();
            Object[] names = annotation.names();
            if (ArrayUtils.isNotEmpty((Object[])names)) {
                HashSet<Object> namesSet = new HashSet<Object>(Arrays.asList(names));
                HashSet<Object> selectedNamesSet = new HashSet(Arrays.asList(enumConstants).stream().map(Enum::toString).collect(Collectors.toList()));
                switch (mode) {
                    case INCLUDE: {
                        selectedNamesSet = namesSet;
                        break;
                    }
                    case EXCLUDE: {
                        selectedNamesSet.removeAll(namesSet);
                        break;
                    }
                }
                return this.listOfObjectsFrom(selectedNamesSet.toArray());
            }
            return this.listOfObjectsFrom(enumConstants);
        }
        return null;
    }

    private List<List<Object>> listOfObjectsFrom(Object[] parameters) {
        return Arrays.stream(parameters).map(xva$0 -> Arrays.asList(xva$0)).collect(Collectors.toList());
    }

    private DataTable createParametersTableFrom(String columnNamesString, List<List<Object>> parametersList) {
        int numberOfColumns = parametersList.isEmpty() ? 0 : parametersList.get(0).size();
        List<String> columnNames = this.split(columnNamesString, numberOfColumns);
        return DataTable.withHeaders(columnNames).andRows(parametersList).build();
    }

    private List<String> split(String columnNamesString, int numberOfColumns) {
        if (StringUtils.isEmpty((CharSequence)columnNamesString)) {
            return this.numberedColumnHeadings(numberOfColumns);
        }
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)columnNamesString);
    }

    private List<String> numberedColumnHeadings(int numberOfColumns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < numberOfColumns; ++i) {
            columnNames.add("Parameter " + (i + 1));
        }
        return columnNames;
    }

    private boolean findParameterizedTests(Method method) {
        return method.getAnnotation(ParameterizedTest.class) != null && (this.isAValueSourceAnnotatedMethod(method) || this.isACsvFileSourceAnnotatedMethod(method) || this.isACsvSourceAnnotatedMethod(method) || this.isAEnumSourceAnnotatedMethod(method) || this.isAMethodSourceAnnotatedMethod(method));
    }

    private boolean isAValueSourceAnnotatedMethod(Method method) {
        return method.getAnnotation(ValueSource.class) != null;
    }

    private boolean isAEnumSourceAnnotatedMethod(Method method) {
        return method.getAnnotation(EnumSource.class) != null;
    }

    private boolean isACsvSourceAnnotatedMethod(Method method) {
        return method.getAnnotation(CsvSource.class) != null;
    }

    private boolean isACsvFileSourceAnnotatedMethod(Method method) {
        return method.getAnnotation(CsvFileSource.class) != null;
    }

    private boolean isAMethodSourceAnnotatedMethod(Method method) {
        return method.getAnnotation(MethodSource.class) != null;
    }

    private boolean isAnArgumentsSourceAnnotatedMethod(Method method) {
        return method.getAnnotation(ArgumentsSource.class) != null;
    }
}

