/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.serenitybdd.junit5.AssertThrowsAdvice;
import net.serenitybdd.junit5.JUnit5DataDrivenAnnotations;
import net.serenitybdd.junit5.JUnit5TestClassAnnotations;
import net.serenitybdd.junit5.JUnit5TestMethodAnnotations;
import net.serenitybdd.junit5.ParameterizedTestsOutcomeAggregator;
import net.serenitybdd.junit5.SerenityJUnit5Extension;
import net.serenitybdd.junit5.SerenityTestExecutionSummary;
import net.serenitybdd.junit5.TestMethodConfiguration;
import net.serenitybdd.junit5.utils.ClassUtil;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.configuration.SystemPropertiesConfiguration;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.domain.TestClassHierarchy;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.logging.ConsoleLoggingListener;
import net.thucydides.model.reports.ReportService;
import net.thucydides.model.steps.StepListener;
import net.thucydides.model.steps.TestSourceType;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityTestExecutionListener
implements TestExecutionListener {
    private static final List<Class> expectedExceptions = Collections.synchronizedList(new ArrayList());
    private static final Logger logger = LoggerFactory.getLogger(SerenityTestExecutionListener.class);
    private ReportService reportService;
    private SerenityTestExecutionSummary summary;
    private Pages pages;
    private final Map<String, DataTable> dataTables = Collections.synchronizedMap(new HashMap());
    private boolean isSerenityTest = false;
    private final Map<Class<?>, String> testCaseDisplayNames = new HashMap();

    private static File getOutputDirectory() {
        SystemPropertiesConfiguration systemPropertiesConfiguration = new SystemPropertiesConfiguration((EnvironmentVariables)new SystemEnvironmentVariables());
        return systemPropertiesConfiguration.getOutputDirectory();
    }

    public synchronized void testPlanExecutionStarted(TestPlan testPlan) {
        this.summary = new SerenityTestExecutionSummary(testPlan);
        testPlan.getRoots().forEach(root -> {
            Set children = testPlan.getChildren(root.getUniqueId());
            children.stream().filter(this::isClassSource).filter(this::isASerenityTest).forEach(this::configureParameterizedTestDataFor);
        });
    }

    private boolean isASerenityTest(TestIdentifier child) {
        return SerenityTestExecutionListener.isSerenityTestClass(((ClassSource)child.getSource().get()).getJavaClass());
    }

    private void configureParameterizedTestDataFor(TestIdentifier serenityTest) {
        Class javaClass = ((ClassSource)serenityTest.getSource().get()).getJavaClass();
        Map<String, DataTable> parameterTablesForClass = JUnit5DataDrivenAnnotations.forClass(javaClass).getParameterTables();
        if (!parameterTablesForClass.isEmpty()) {
            this.dataTables.putAll(parameterTablesForClass);
        }
    }

    public synchronized void testPlanExecutionFinished(TestPlan testPlan) {
        if (!this.isSerenityTest) {
            return;
        }
        ArrayList testIdentifiers = new ArrayList();
        ArrayList<TestIdentifier> parameterizedTestIdentifiers = new ArrayList<TestIdentifier>();
        testPlan.getRoots().forEach(testIdentifier -> this.generateReportsForTest(testPlan, (TestIdentifier)testIdentifier, testIdentifiers, (List<TestIdentifier>)parameterizedTestIdentifiers));
        testIdentifiers.forEach(this::generateReports);
        this.generateReportsForParameterizedTests(parameterizedTestIdentifiers);
        logger.debug("->TestPlanExecutionFinished " + String.valueOf(testPlan));
    }

    private void generateReportsForTest(TestPlan testPlan, TestIdentifier testIdentifier, List<TestIdentifier> testIdentifiers, List<TestIdentifier> parameterizedTestIdentifiers) {
        logger.debug("->GenerateReportsForTest  " + String.valueOf(testIdentifier));
        if (testIdentifier.getUniqueId().contains("test-template-invocation")) {
            parameterizedTestIdentifiers.add(testIdentifier);
        } else {
            testIdentifiers.add(testIdentifier);
        }
        testPlan.getChildren(testIdentifier).forEach(ti -> this.generateReportsForTest(testPlan, (TestIdentifier)ti, testIdentifiers, parameterizedTestIdentifiers));
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (!this.isSerenityTest) {
            return;
        }
        this.processTestMethodAnnotationsFor(testIdentifier);
    }

    private void processTestMethodAnnotationsFor(TestIdentifier testIdentifier) {
        Optional testSource = testIdentifier.getSource();
        if (testSource.isPresent() && testSource.get() instanceof MethodSource) {
            MethodSource methodTestSource = (MethodSource)testIdentifier.getSource().get();
            String className = methodTestSource.getClassName();
            String methodName = methodTestSource.getMethodName();
            String methodParameterTypes = methodTestSource.getMethodParameterTypes();
            List methodParameterClasses = null;
            if (methodParameterTypes != null && !methodParameterTypes.isEmpty()) {
                methodParameterClasses = Arrays.asList(methodParameterTypes.split(",")).stream().map(parameterClassName -> {
                    try {
                        return ClassUtil.forName(parameterClassName.trim(), this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Problem when getting parameter classes ", (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
            }
            try {
                if (this.isIgnored(this.getProcessedMethod(className, methodName, methodParameterClasses))) {
                    this.startTestAtEventBus(testIdentifier);
                    this.eventBusFor(testIdentifier).testIgnored();
                    this.eventBusFor(testIdentifier).testFinished();
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException exception) {
                logger.error("Exception when processing method annotations", (Throwable)exception);
            }
        }
    }

    private Method getProcessedMethod(String className, String methodName, List<Class> methodParameterClasses) throws NoSuchMethodException, ClassNotFoundException {
        if (!this.isNullOrEmpty(methodParameterClasses)) {
            Class[] classesArray = new Class[methodParameterClasses.size()];
            return Class.forName(className).getMethod(methodName, methodParameterClasses.toArray(classesArray));
        }
        if (Arrays.stream(Class.forName(className).getDeclaredMethods()).anyMatch(method -> method.getName().equals(methodName))) {
            return Class.forName(className).getDeclaredMethod(methodName, new Class[0]);
        }
        return Class.forName(className).getMethod(methodName, new Class[0]);
    }

    private boolean isNullOrEmpty(List<Class> methodParameterClasses) {
        if (methodParameterClasses == null || methodParameterClasses.isEmpty()) {
            return true;
        }
        return methodParameterClasses.stream().allMatch(Objects::isNull);
    }

    private boolean isIgnored(Method child) {
        return child.getAnnotation(Disabled.class) != null;
    }

    private void startTestAtEventBus(TestIdentifier testIdentifier) {
        this.eventBusFor(testIdentifier).setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
        String displayName = this.removeEndBracketsFromDisplayName(testIdentifier.getDisplayName());
        if (this.isMethodSource(testIdentifier)) {
            String className = ((MethodSource)testIdentifier.getSource().get()).getClassName();
            try {
                this.eventBusFor(testIdentifier).testStarted(Optional.ofNullable(displayName).orElse("Initialisation"), Class.forName(className));
            }
            catch (ClassNotFoundException exception) {
                logger.error("Exception when starting test at event bus ", (Throwable)exception);
            }
        }
    }

    private String removeEndBracketsFromDisplayName(String displayName) {
        if (displayName != null && displayName.endsWith("()")) {
            displayName = displayName.substring(0, displayName.length() - 2);
        }
        return displayName;
    }

    public synchronized void executionStarted(TestIdentifier testIdentifier) {
        Class testClass;
        logger.trace("-->Execution started with TI " + String.valueOf(testIdentifier));
        if (!testIdentifier.getSource().isPresent()) {
            logger.trace("No action done at executionStarted because testIdentifier is null");
            return;
        }
        if (this.isTestContainer(testIdentifier) && this.isClassSource(testIdentifier)) {
            testClass = ((ClassSource)testIdentifier.getSource().get()).getJavaClass();
            this.isSerenityTest = SerenityTestExecutionListener.isSerenityTestClass(testClass);
            if (!this.isSerenityTest) {
                logger.trace("-->Execution started but no SerenityClass " + String.valueOf(testClass));
                return;
            }
            logger.trace("-->Execution started " + String.valueOf(testIdentifier) + "----" + testIdentifier.getDisplayName() + "--" + String.valueOf(testIdentifier.getType()) + "--" + String.valueOf(testIdentifier.getSource()));
            logger.trace("-->TestSuiteStarted " + String.valueOf(testClass));
            String testClassName = null;
            if (testIdentifier.getSource().isPresent() && testIdentifier.getSource().get() instanceof ClassSource) {
                testClassName = ((ClassSource)testIdentifier.getSource().get()).getClassName();
            }
            TestClassHierarchy.getInstance().testSuiteStarted(testClassName, testIdentifier.getUniqueId(), testIdentifier.getDisplayName(), (String)testIdentifier.getParentId().orElse(null));
            this.eventBusFor(testIdentifier).getBaseStepListener().clearTestOutcomes();
            this.eventBusFor(testIdentifier).testSuiteStarted(testClass, testIdentifier.getDisplayName());
            this.testCaseDisplayNames.put(testClass, testIdentifier.getDisplayName());
        }
        if (this.isMethodSource(testIdentifier)) {
            String sourceMethod;
            DataTable dataTable;
            MethodSource methodSource = (MethodSource)testIdentifier.getSource().get();
            if (this.isSimpleTest(testIdentifier)) {
                testClass = ((MethodSource)testIdentifier.getSource().get()).getJavaClass();
                this.testStarted(methodSource, testIdentifier, testClass);
            }
            if ((dataTable = this.dataTables.get(sourceMethod = methodSource.getJavaClass().getCanonicalName() + "." + methodSource.getMethodName())) != null) {
                logger.trace("FoundDataTable " + String.valueOf(dataTable) + " " + String.valueOf(dataTable.getRows()));
                if (this.isSimpleTest(testIdentifier)) {
                    this.eventBusFor(testIdentifier).useExamplesFrom(dataTable);
                    logger.trace("-->EventBus.useExamplesFrom" + String.valueOf(dataTable));
                    int rowNumber = this.getTestTemplateInvocationNumber(testIdentifier);
                    logger.trace("-->EventBus.exampleStarted " + rowNumber + "--" + String.valueOf(dataTable.row(rowNumber).toStringMap()));
                    logger.trace("-->EventBus.useExamplesFrom" + String.valueOf(dataTable) + " with parameter set number " + rowNumber);
                    this.eventBusFor(testIdentifier).exampleStarted(dataTable.row(rowNumber).toStringMap());
                }
            }
        }
    }

    private boolean isTestContainer(TestIdentifier testIdentifier) {
        return TestDescriptor.Type.CONTAINER == testIdentifier.getType();
    }

    public synchronized void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!this.isSerenityTest) {
            return;
        }
        logger.trace("-->Execution finished " + String.valueOf(testIdentifier));
        logger.trace("-->Execution finished " + testIdentifier.getDisplayName() + "--" + String.valueOf(testIdentifier.getType()) + "--" + String.valueOf(testIdentifier.getSource()) + " with result " + String.valueOf(testExecutionResult.getStatus()));
        if (!testIdentifier.getSource().isPresent()) {
            logger.debug("No action done at executionFinished because testIdentifier is null");
            return;
        }
        if (this.isTestContainer(testIdentifier) && this.isClassSource(testIdentifier)) {
            logger.trace("-->EventBus.TestSuiteFinished " + String.valueOf(((ClassSource)testIdentifier.getSource().get()).getJavaClass()));
            this.eventBusFor(testIdentifier).testSuiteFinished();
        }
        if (this.isSimpleTest(testIdentifier) && this.isMethodSource(testIdentifier)) {
            MethodSource methodSource = (MethodSource)testIdentifier.getSource().get();
            String sourceMethod = methodSource.getClassName() + "." + methodSource.getMethodName();
            this.testFinished(testIdentifier, methodSource, testExecutionResult);
            DataTable dataTable = this.dataTables.get(sourceMethod);
            if (dataTable != null) {
                this.eventBusFor(testIdentifier).exampleFinished();
            }
        }
        this.recordSummaryData(testIdentifier, testExecutionResult);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recordSummaryData(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        try {
            switch (testExecutionResult.getStatus()) {
                case SUCCESSFUL: {
                    if (testIdentifier.isContainer()) {
                        this.summary.containersSucceeded.incrementAndGet();
                    }
                    if (!testIdentifier.isTest()) return;
                    this.summary.testsSucceeded.incrementAndGet();
                    return;
                }
                case ABORTED: {
                    if (testIdentifier.isContainer()) {
                        this.summary.containersAborted.incrementAndGet();
                    }
                    if (!testIdentifier.isTest()) return;
                    this.summary.testsAborted.incrementAndGet();
                    return;
                }
                case FAILED: {
                    if (testIdentifier.isContainer()) {
                        this.summary.containersFailed.incrementAndGet();
                    }
                    if (testIdentifier.isTest()) {
                        this.summary.testsFailed.incrementAndGet();
                    }
                    testExecutionResult.getThrowable().ifPresent(throwable -> this.summary.addFailure(testIdentifier, (Throwable)throwable));
                    this.eventBusFor(testIdentifier).testFailed((Throwable)testExecutionResult.getThrowable().get());
                    return;
                }
                default: {
                    throw new PreconditionViolationException("Unsupported execution status:" + String.valueOf(testExecutionResult.getStatus()));
                }
            }
        }
        finally {
            expectedExceptions.clear();
        }
    }

    private void testFinished(TestIdentifier testIdentifier, MethodSource methodSource, TestExecutionResult testExecutionResult) {
        this.updateResultsUsingTestAnnotations(testIdentifier, methodSource);
        TestResult result = this.eventBusFor(testIdentifier).getBaseStepListener().getCurrentTestOutcome().getResult();
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED && result == TestResult.SUCCESS) {
            this.updateResultsUsingTestExecutionResult(testIdentifier, testExecutionResult);
        } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED && result.isLessSevereThan(TestResult.FAILURE)) {
            this.updateResultsUsingTestExecutionResult(testIdentifier, testExecutionResult);
        }
        this.eventBusFor(testIdentifier).testFinished();
        this.eventBusFor(testIdentifier).setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
    }

    private void updateResultsUsingTestExecutionResult(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        testExecutionResult.getThrowable().ifPresent(cause -> this.eventBusFor(testIdentifier).getBaseStepListener().updateCurrentStepFailureCause(cause));
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            this.eventBusFor(testIdentifier).getBaseStepListener().overrideResultTo(TestResult.ABORTED);
        }
    }

    private void updateResultsUsingTestAnnotations(TestIdentifier testIdentifier, MethodSource methodSource) {
        if (TestMethodConfiguration.forMethod(methodSource.getJavaMethod()).isManual()) {
            this.setToManual(testIdentifier, methodSource);
        }
        expectedExceptions.forEach(ex -> this.updateResultsForExpectedException(testIdentifier, (Class<? extends Throwable>)ex));
    }

    private void setToManual(TestIdentifier testIdentifier, MethodSource methodSource) {
        this.eventBusFor(testIdentifier).testIsManual();
        TestResult result = TestMethodConfiguration.forMethod(methodSource.getJavaMethod()).getManualResult();
        this.eventBusFor(testIdentifier).getBaseStepListener().recordManualTestResult(result);
    }

    private void updateResultsForExpectedException(TestIdentifier testIdentifier, Class<? extends Throwable> expected) {
        this.eventBusFor(testIdentifier).exceptionExpected(expected);
    }

    private boolean isSimpleTest(TestIdentifier testIdentifier) {
        return testIdentifier.getType() == TestDescriptor.Type.TEST;
    }

    private boolean isClassSource(TestIdentifier testId) {
        return testId.getSource().isPresent() && testId.getSource().get() instanceof ClassSource;
    }

    private boolean isMethodSource(TestIdentifier testId) {
        return testId.getSource().isPresent() && testId.getSource().get() instanceof MethodSource;
    }

    private void testStarted(MethodSource methodSource, TestIdentifier testIdentifier, Class<?> testClass) {
        if (this.testingThisTest(testIdentifier, testClass)) {
            this.startTestSuiteForFirstTest(testIdentifier);
            logger.debug(String.valueOf(Thread.currentThread()) + " Test started " + String.valueOf(testIdentifier));
            this.eventBusFor(testIdentifier).clear();
            this.eventBusFor(testIdentifier).setTestSource(TestSourceType.TEST_SOURCE_JUNIT5.getValue());
            String testName = StringUtils.isNotEmpty((CharSequence)testIdentifier.getDisplayName()) ? testIdentifier.getDisplayName() : methodSource.getMethodName();
            try {
                Method javaMethod = methodSource.getJavaMethod();
                if (JUnit5TestClassAnnotations.forTest(testClass).getDisplayNameGeneration(javaMethod).isPresent()) {
                    testName = JUnit5TestClassAnnotations.forTest(testClass).getDisplayNameGeneration(javaMethod).get();
                }
                if (JUnit5TestMethodAnnotations.forTest(javaMethod).getDisplayName().isPresent()) {
                    testName = JUnit5TestMethodAnnotations.forTest(javaMethod).getDisplayName().get();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eventBusFor(testIdentifier).testStarted(Optional.ofNullable(testName).orElse("Initialisation"), methodSource.getJavaClass(), methodSource.getMethodName(), testIdentifier.getUniqueId(), testIdentifier.getParentId().orElse(testIdentifier.getUniqueId()));
            if (this.isPending(methodSource)) {
                this.eventBusFor(testIdentifier).testPending();
            }
        }
    }

    private synchronized StepEventBus eventBusFor(TestIdentifier testIdentifier) {
        String uniqueTestId = testIdentifier.getUniqueId();
        StepEventBus currentEventBus = StepEventBus.eventBusFor((Object)uniqueTestId);
        if (!currentEventBus.isBaseStepListenerRegistered()) {
            File outputDirectory = SerenityTestExecutionListener.getOutputDirectory();
            BaseStepListener baseStepListener = Listeners.getBaseStepListener().withOutputDirectory(outputDirectory);
            currentEventBus.registerListener((StepListener)baseStepListener);
            currentEventBus.registerListener((StepListener)new ConsoleLoggingListener(currentEventBus.getEnvironmentVariables()));
            logger.trace("  -> ADDED BASE LISTENER " + String.valueOf(baseStepListener));
            StepListener loggingListener = Listeners.getLoggingListener();
            currentEventBus.registerListener(loggingListener);
            logger.trace("  -> ADDED LOGGING LISTENER " + String.valueOf(loggingListener));
        }
        logger.trace("SETTING EVENT BUS FOR THREAD " + String.valueOf(Thread.currentThread()) + " TO " + String.valueOf(currentEventBus));
        StepEventBus.setCurrentBusToEventBusFor((Object)uniqueTestId);
        return currentEventBus;
    }

    private boolean isPending(MethodSource methodSource) {
        try {
            return TestMethodConfiguration.forMethod(methodSource.getJavaMethod()).isPending();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean testingThisTest(TestIdentifier testIdentifier, Class<?> testClass) {
        if (this.isMethodSource(testIdentifier)) {
            MethodSource methodSource = (MethodSource)testIdentifier.getSource().get();
            return testClass.equals(methodSource.getJavaClass());
        }
        return false;
    }

    private void startTestSuiteForFirstTest(TestIdentifier testIdentifier) {
        if (this.isMethodSource(testIdentifier)) {
            Class testCase = ((MethodSource)testIdentifier.getSource().get()).getJavaClass();
            logger.trace("-->TestSuiteStarted " + String.valueOf(testCase));
            String testSuiteName = this.testCaseDisplayNames.getOrDefault(testCase, testCase.getSimpleName());
            this.eventBusFor(testIdentifier).testSuiteStarted(((MethodSource)testIdentifier.getSource().get()).getJavaClass(), testSuiteName);
        }
    }

    public List<TestOutcome> getTestOutcomes(TestIdentifier testIdentifier) {
        logger.trace("GET TEST OUTCOMES FOR " + String.valueOf(testIdentifier));
        logger.trace(" - BASE STEP LISTENER: " + String.valueOf(this.eventBusFor(testIdentifier).getBaseStepListener()));
        List testOutcomes = this.eventBusFor(testIdentifier).getBaseStepListener().getTestOutcomes();
        logger.trace(" - EVENT TEST OUTCOMES: " + String.valueOf(testOutcomes));
        logger.trace(" - THREAD TEST OUTCOMES: " + String.valueOf(StepEventBus.getParallelEventBus().getBaseStepListener().getTestOutcomes()));
        return testOutcomes;
    }

    private void generateReports(TestIdentifier testIdentifier) {
        logger.trace("GENERATE REPORTS FOR TEST " + testIdentifier.getUniqueId());
        this.generateReportsFor(this.getTestOutcomes(testIdentifier));
        StepEventBus.clearEventBusFor((Object)testIdentifier.getUniqueId());
    }

    private void generateReportsForParameterizedTests(List<TestIdentifier> testIdentifiers) {
        logger.trace("GENERATE REPORTS FOR PARAMETERIZED TESTS " + String.valueOf(testIdentifiers));
        List<TestOutcome> allTestOutcomes = testIdentifiers.stream().map(this::getTestOutcomes).flatMap(Collection::stream).collect(Collectors.toList());
        ParameterizedTestsOutcomeAggregator parameterizedTestsOutcomeAggregator = new ParameterizedTestsOutcomeAggregator(allTestOutcomes);
        this.generateReportsFor(parameterizedTestsOutcomeAggregator.aggregateTestOutcomesByTestMethods());
        testIdentifiers.stream().map(TestIdentifier::getUniqueId).forEach(StepEventBus::clearEventBusFor);
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
        this.getReportService().generateConfigurationsReport();
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(SerenityTestExecutionListener.getOutputDirectory(), (Collection)ReportService.getDefaultReporters());
        }
        return this.reportService;
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injector().injectAnnotatedPagesObjectInto(testCase, this.pages);
    }

    public static void addExpectedException(Class exceptionClass) {
        expectedExceptions.add(exceptionClass);
    }

    static boolean isSerenityTestClass(Class<?> testClass) {
        return SerenityTestExecutionListener.classNestStructure(testClass).stream().flatMap(clazz -> Stream.of((ExtendWith[])clazz.getAnnotationsByType(ExtendWith.class))).anyMatch(annotation -> Arrays.asList(annotation.value()).contains(SerenityJUnit5Extension.class));
    }

    private static List<Class<?>> classNestStructure(Class<?> testClass) {
        ArrayList nestedStructure = new ArrayList();
        nestedStructure.add(testClass);
        for (Class<?> declaringClass = testClass.getDeclaringClass(); declaringClass != null; declaringClass = declaringClass.getDeclaringClass()) {
            nestedStructure.add(declaringClass);
        }
        return nestedStructure;
    }

    private int getTestTemplateInvocationNumber(TestIdentifier testIdentifier) {
        return SerenityTestExecutionListener.getTestTemplateInvocationNumber(testIdentifier.getUniqueId());
    }

    static int getTestTemplateInvocationNumber(String uniqueTestIdentifier) {
        if (!uniqueTestIdentifier.contains("test-template-invocation")) {
            return -1;
        }
        int index1 = uniqueTestIdentifier.lastIndexOf("#");
        int index2 = uniqueTestIdentifier.lastIndexOf("]");
        return Integer.parseInt(uniqueTestIdentifier.substring(index1 + 1, index2)) - 1;
    }

    static {
        ByteBuddyAgent.install();
        new ByteBuddy().rebase(Assertions.class).visit((AsmVisitorWrapper)Advice.to(AssertThrowsAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"assertThrows"))).make().load(Assertions.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }
}

