/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.lang.reflect.Method;
import java.util.Arrays;
import net.serenitybdd.annotations.Manual;
import net.serenitybdd.annotations.Pending;
import net.thucydides.model.domain.TestResult;

public class TestMethodConfiguration {
    private final Method method;

    public TestMethodConfiguration(Method method) {
        this.method = method;
    }

    public static TestMethodConfiguration forMethod(Method method) {
        return new TestMethodConfiguration(method);
    }

    public boolean isManual() {
        return this.method.getAnnotation(Manual.class) != null;
    }

    public TestResult getManualResult() {
        return this.method.getAnnotation(Manual.class).result();
    }

    public boolean isIgnored() {
        return Arrays.stream(this.method.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals("Ignore"));
    }

    public boolean isPending() {
        return this.method.getAnnotation(Pending.class) != null;
    }

    public String getManualResultReason() {
        return this.method.getAnnotation(Manual.class).reason();
    }
}

