/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import com.google.common.base.Splitter;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Tag;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.util.EnvironmentVariables;

public class CucumberParser {
    private final String locale;
    private final String encoding;

    public CucumberParser() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public CucumberParser(EnvironmentVariables environmentVariables) {
        this(ThucydidesSystemProperty.FEATURE_FILE_LANGUAGE.from(environmentVariables, "en"), environmentVariables);
    }

    public CucumberParser(String locale, EnvironmentVariables environmentVariables) {
        this.locale = locale;
        this.encoding = ThucydidesSystemProperty.FEATURE_FILE_ENCODING.from(environmentVariables, Charset.defaultCharset().name());
    }

    public Optional<Narrative> loadFeatureNarrative(File narrativeFile) {
        ArrayList<String> listOfFiles = new ArrayList<String>();
        listOfFiles.add(narrativeFile.getAbsolutePath());
        List cucumberFeatures = CucumberFeature.load((ResourceLoader)new MultiLoader(CucumberParser.class.getClassLoader()), listOfFiles);
        try {
            if (cucumberFeatures.size() == 0) {
                return Optional.empty();
            }
            CucumberFeature cucumberFeature = (CucumberFeature)cucumberFeatures.get(0);
            GherkinDocument gherkinDocument = cucumberFeature.getGherkinFeature();
            if (this.featureFileCouldNotBeReadFor(gherkinDocument)) {
                return Optional.empty();
            }
            String cardNumber = this.findCardNumberInTags(this.tagsDefinedIn(cucumberFeature));
            List<String> versionNumbers = this.findVersionNumberInTags(this.tagsDefinedIn(cucumberFeature));
            String title = gherkinDocument.getFeature().getName();
            String text = gherkinDocument.getFeature().getDescription();
            String id = this.getIdFromName(title);
            return Optional.of(new Narrative(Optional.ofNullable(title), Optional.ofNullable(id), Optional.ofNullable(cardNumber), versionNumbers, "feature", text != null ? text : ""));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    private String getIdFromName(String name) {
        return name.replaceAll("[\\s_]", "-").toLowerCase();
    }

    private boolean featureFileCouldNotBeReadFor(GherkinDocument gherkinStructure) {
        return gherkinStructure.getFeature() == null;
    }

    private String filterOutCommentsFrom(String gherkin) {
        StringBuilder filteredGherkin = new StringBuilder();
        Scanner scanner = new Scanner(gherkin);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.trim().startsWith("#")) continue;
            filteredGherkin.append(line).append(System.lineSeparator());
        }
        scanner.close();
        return filteredGherkin.toString();
    }

    private List<Tag> tagsDefinedIn(CucumberFeature cucumberFeature) {
        return cucumberFeature.getGherkinFeature().getFeature().getTags();
    }

    private String findCardNumberInTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@issue:")) {
                return tag.getName().replaceAll("@issue:", "");
            }
            if (!tag.getName().toLowerCase().startsWith("@issues:")) continue;
            String issueNumberList = tag.getName().replaceAll("@issues:", "");
            List issueNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)issueNumberList);
            return (String)issueNumberTags.get(0);
        }
        return null;
    }

    private List<String> findVersionNumberInTags(List<Tag> tags) {
        ArrayList<String> versionNumbers = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@version:")) {
                versionNumbers.add(tag.getName().replaceAll("@version:", ""));
                continue;
            }
            if (!tag.getName().toLowerCase().startsWith("@versions:")) continue;
            String versionNumberList = tag.getName().replaceAll("@versions:", "");
            List versionNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)versionNumberList);
            versionNumbers.addAll(versionNumberTags);
        }
        return versionNumbers;
    }
}

