/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;

public class ReportData {
    private final String title;
    private final String contents;

    public ReportData(String title, String contents) {
        this.title = title;
        this.contents = contents;
    }

    public static ReportDataBuilder withTitle(String title) {
        return new ReportDataBuilder(title);
    }

    public String getTitle() {
        return this.title;
    }

    public String getContents() {
        return this.contents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportData that = (ReportData)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return this.contents != null ? this.contents.equals(that.contents) : that.contents == null;
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.contents != null ? this.contents.hashCode() : 0);
        return result;
    }

    public static class ReportDataBuilder {
        private final String title;

        public ReportDataBuilder(String title) {
            this.title = title;
        }

        public ReportData andContents(String contents) {
            return new ReportData(this.title, contents);
        }

        public ReportData fromFile(Path source, Charset encoding) throws IOException {
            byte[] encoded = Files.readAllBytes(source);
            return new ReportData(this.title, new String(encoded, encoding));
        }
    }
}

