/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Narrative {
    private final Optional<String> title;
    private final Optional<String> id;
    private final Optional<String> cardNumber;
    private final List<String> versionNumbers;
    private final String text;
    private String type;

    public Narrative(Optional<String> title, Optional<String> id, Optional<String> cardNumber, List<String> versionNumbers, String type, String text) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)text);
        this.title = title;
        this.id = id;
        this.cardNumber = cardNumber;
        this.versionNumbers = versionNumbers;
        this.type = type;
        this.text = text;
    }

    public Narrative(String type, String text) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), NewList.of(new String[0]), type, text);
    }

    public Optional<String> getId() {
        return this.id;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getCardNumber() {
        return this.cardNumber;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getVersionNumbers() {
        return NewList.copyOf(this.versionNumbers);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("title", this.title).append("text", (Object)this.text).append("type", (Object)this.type).toString();
    }
}

