/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TestResult {
    COMPROMISED(5, true, "Compromised tests"),
    ERROR(4, true, "Broken tests"),
    FAILURE(3, true, "Failing tests"),
    SKIPPED(2, false, "Skipped tests"),
    IGNORED(2, false, "Ignored tests"),
    PENDING(2, false, "Pending tests"),
    SUCCESS(1, true, "Passing tests"),
    UNDEFINED(0, false, "Undefined tests");

    private final int priority;
    private final boolean executedResultsCount;
    private final String label;
    private static Logger logger;

    private TestResult(int priority, boolean executedResultsCount, String label) {
        this.priority = priority;
        this.executedResultsCount = executedResultsCount;
        this.label = label;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean overrides(TestResult result) {
        return this.priority > result.priority;
    }

    public boolean isMoreSevereThan(TestResult otherResult) {
        return this.ordinal() > otherResult.ordinal();
    }

    public String getLabel() {
        return this.label;
    }

    public static boolean existsWithName(String expectedResult) {
        try {
            TestResult.valueOf(expectedResult);
        }
        catch (IllegalArgumentException noMatchingEnumValue) {
            logger.warn("No matching test result value found for {}", (Object)expectedResult);
            return false;
        }
        return true;
    }

    public boolean isAtLeast(TestResult minimumTestResult) {
        return this.priority >= minimumTestResult.priority;
    }

    public boolean executedResultsCount() {
        return this.executedResultsCount;
    }

    static {
        logger = LoggerFactory.getLogger((String)"net.thucydides.core.model.TestResult");
    }
}

