/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.gson.Gson;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ResultIconFormatter;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.requirements.tree.Node;

public class JSONRequirementsTree {
    private final List<Node> nodes;

    public JSONRequirementsTree(List<Requirement> requirements, RequirementsOutcomes requirementsOutcomes) {
        this.nodes = requirements.stream().map(requirement -> this.toNode((Requirement)requirement, requirementsOutcomes)).collect(Collectors.toList());
    }

    public static JSONRequirementsTree forRequirements(List<Requirement> requirements, RequirementsOutcomes requirementsOutcomes) {
        return new JSONRequirementsTree(requirements, requirementsOutcomes);
    }

    public static JSONRequirementsTree forRequirements(List<Requirement> requirements) {
        return new JSONRequirementsTree(requirements, null);
    }

    private Node toNode(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        List<Node> children = requirement.getChildren().stream().map(child -> this.toNode((Requirement)child, requirementsOutcomes)).distinct().collect(Collectors.toList());
        TestResult result = this.matchingOutcome(requirement, requirementsOutcomes);
        String label = new ResultIconFormatter().forResult(result);
        String report = new ReportNameProvider().forRequirement(requirement);
        return new Node(requirement.getName(), report, label, children);
    }

    private TestResult matchingOutcome(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        if (requirementsOutcomes == null) {
            return TestResult.UNDEFINED;
        }
        Optional<RequirementOutcome> matchingOutcome = requirementsOutcomes.getFlattenedRequirementOutcomes().stream().filter(outcome -> outcome.getRequirement().equals(requirement)).findFirst();
        if (matchingOutcome.isPresent()) {
            if (matchingOutcome.get().getTestOutcomes().getTotal() == 0) {
                return TestResult.PENDING;
            }
            return matchingOutcome.get().getTestOutcomes().getResult();
        }
        return TestResult.UNDEFINED;
    }

    public String asString() {
        Gson gson = new Gson();
        return gson.toJson(this.nodes);
    }

    public Boolean isALeafNode() {
        return this.nodes.size() == 1 && this.nodes.get(0).getNodes().isEmpty();
    }
}

