/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.core.requirements.model.cucumber.ExampleRowResultIcon;
import net.thucydides.core.requirements.model.cucumber.NamedScenario;
import net.thucydides.core.requirements.model.cucumber.RenderedExampleTable;
import net.thucydides.core.requirements.model.cucumber.ScenarioDisplayOption;
import net.thucydides.core.requirements.model.cucumber.ScenarioReport;

public class IdentifiedScenario
extends NamedScenario {
    private Feature feature;
    private String scenarioReport;
    private ScenarioDefinition scenarioDefinition;

    protected IdentifiedScenario(Feature feature, ScenarioDefinition scenarioDefinition) {
        this.feature = feature;
        this.scenarioReport = ScenarioReport.forScenario(scenarioDefinition.getName()).inFeature(feature);
        this.scenarioDefinition = scenarioDefinition;
    }

    @Override
    public Optional<String> asGivenWhenThen() {
        String renderedDescription = " > **" + this.scenarioDefinition.getName() + "**  " + this.resultToken() + System.lineSeparator() + this.scenarioDefinition.getSteps().stream().map(step -> " > " + step.getKeyword() + this.withEscapedParameterFields(step.getText()) + "  ").collect(Collectors.joining(System.lineSeparator()));
        renderedDescription = renderedDescription + System.lineSeparator() + "[<i class=\"fa fa-info-circle\"></i> More details](" + this.scenarioReport + ")" + System.lineSeparator();
        return Optional.of(renderedDescription);
    }

    private String resultToken() {
        return "{result:" + this.feature.getName() + "!" + this.scenarioDefinition.getName() + "}";
    }

    private String withEscapedParameterFields(String text) {
        return text.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    @Override
    public Optional<String> asExampleTable() {
        return this.asExampleTable(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asExampleTable(ScenarioDisplayOption withDisplayOption) {
        if (!(this.scenarioDefinition instanceof ScenarioOutline)) {
            return Optional.empty();
        }
        ScenarioOutline scenarioOutline = (ScenarioOutline)this.scenarioDefinition;
        return Optional.of(scenarioOutline.getExamples().stream().map(example -> this.renderedFormOf((Examples)example, withDisplayOption)).collect(Collectors.joining(System.lineSeparator())));
    }

    private String renderedFormOf(Examples exampleTable, ScenarioDisplayOption displayOption) {
        ExampleRowResultIcon exampleRowCounter = new ExampleRowResultIcon(this.feature.getName() + "!" + this.scenarioDefinition.getName());
        StringBuilder renderedExampleTable = new StringBuilder();
        String tableName = RenderedExampleTable.nameFor(exampleTable);
        if (tableName.isEmpty()) {
            tableName = this.scenarioDefinition.getName();
        }
        if (displayOption == ScenarioDisplayOption.WithTitle) {
            String exampleTitle = "### " + tableName;
            renderedExampleTable.append(exampleTitle);
        }
        renderedExampleTable.append(System.lineSeparator());
        renderedExampleTable.append(RenderedExampleTable.descriptionFor(exampleTable));
        renderedExampleTable.append(RenderedExampleTable.renderedTable(exampleTable, exampleRowCounter));
        renderedExampleTable.append(System.lineSeparator()).append("[<i class=\"fa fa-info-circle\"></i> More details](" + this.scenarioReport + ")").append(System.lineSeparator());
        return renderedExampleTable.toString();
    }
}

