/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import gherkin.ast.DataTable;
import gherkin.ast.Examples;
import gherkin.ast.Node;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import java.util.List;
import java.util.stream.Collectors;

public class RenderCucumber {
    public static String step(Step step) {
        return step.getKeyword() + " " + RenderCucumber.withEscapedParameterFields(step.getText()) + "  " + RenderCucumber.renderedArgument(step.getArgument());
    }

    private static String renderedArgument(Node argument) {
        if (argument instanceof DataTable) {
            return RenderCucumber.renderedDataTable((DataTable)argument);
        }
        if (argument instanceof Examples) {
            return RenderCucumber.renderedExamples((Examples)argument);
        }
        return "";
    }

    public static List<String> examples(List<Examples> examples) {
        return examples.stream().map(RenderCucumber::renderedExamples).collect(Collectors.toList());
    }

    private static String renderedExamples(Examples examples) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append(examples.getKeyword()).append(": ");
        if (examples.getName() != null) {
            renderedTable.append(examples.getName());
        }
        renderedTable.append("  ").append(System.lineSeparator());
        if (examples.getDescription() != null) {
            renderedTable.append(examples.getDescription()).append("  ").append(System.lineSeparator());
        }
        renderedTable.append(System.lineSeparator());
        RenderCucumber.addRow(renderedTable, examples.getTableHeader().getCells());
        RenderCucumber.addSeparatorCells(renderedTable, examples.getTableHeader().getCells().size());
        for (TableRow row : examples.getTableBody()) {
            RenderCucumber.addRow(renderedTable, row.getCells());
        }
        return renderedTable.toString();
    }

    private static String renderedDataTable(DataTable dataTable) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append(System.lineSeparator()).append(System.lineSeparator());
        TableRow header = (TableRow)dataTable.getRows().get(0);
        RenderCucumber.addRow(renderedTable, header.getCells());
        RenderCucumber.addSeparatorCells(renderedTable, header.getCells().size());
        for (int row = 1; row < dataTable.getRows().size(); ++row) {
            RenderCucumber.addRow(renderedTable, ((TableRow)dataTable.getRows().get(row)).getCells());
        }
        return renderedTable.toString();
    }

    private static void addSeparatorCells(StringBuffer renderedTable, int columnCount) {
        renderedTable.append("|");
        for (int col = 0; col < columnCount; ++col) {
            renderedTable.append("-----------").append("|");
        }
        renderedTable.append(System.lineSeparator());
    }

    private static void addRow(StringBuffer renderedTable, List<TableCell> cells) {
        renderedTable.append("|");
        for (TableCell cell : cells) {
            renderedTable.append(cell.getValue()).append(" |");
        }
        renderedTable.append(System.lineSeparator());
    }

    private static String withEscapedParameterFields(String text) {
        return text.replaceAll("<", "{").replaceAll(">", "}");
    }
}

