/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.AllRequirements;
import net.thucydides.core.requirements.ParentRequirementsProvided;
import net.thucydides.core.requirements.ReleaseProvider;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRequirementsService
implements RequirementsService {
    protected List<Requirement> requirements;
    protected List<Release> releases;
    private Map<Requirement, List<Requirement>> requirementAncestors;
    protected final EnvironmentVariables environmentVariables;
    private static final List<Requirement> NO_REQUIREMENTS = Collections.synchronizedList(new ArrayList());
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRequirementsService.class);
    private ReleaseManager releaseManager;

    public BaseRequirementsService(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public abstract List<Requirement> getRequirements();

    public abstract List<? extends RequirementsTagProvider> getRequirementsTagProviders();

    public abstract Optional<ReleaseProvider> getReleaseProvider();

    protected List<Requirement> addParentsTo(List<Requirement> requirements) {
        return this.addParentsTo(requirements, null);
    }

    protected List<Requirement> addParentsTo(List<Requirement> requirements, String parent) {
        ArrayList<Requirement> augmentedRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            List<Requirement> children = requirement.hasChildren() ? this.addParentsTo(requirement.getChildren(), requirement.getName()) : NO_REQUIREMENTS;
            augmentedRequirements.add(requirement.withParent(parent).withChildren(children));
        }
        return augmentedRequirements;
    }

    @Override
    public Optional<Requirement> getParentRequirementFor(TestOutcome testOutcome) {
        try {
            for (RequirementsTagProvider requirementsTagProvider : this.getRequirementsTagProviders()) {
                Optional<Requirement> requirement = this.getParentRequirementOf(testOutcome, requirementsTagProvider);
                if (!requirement.isPresent()) continue;
                return requirement;
            }
        }
        catch (RuntimeException handleTagProvidersElegantly) {
            LOGGER.error("Tag provider failure", (Throwable)handleTagProvidersElegantly);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag tag) {
        try {
            for (RequirementsTagProvider requirementsTagProvider : this.getRequirementsTagProviders()) {
                Optional<Requirement> requirement = requirementsTagProvider.getRequirementFor(tag);
                if (!requirement.isPresent()) continue;
                return requirement;
            }
        }
        catch (RuntimeException handleTagProvidersElegantly) {
            LOGGER.error("Tag provider failure", (Throwable)handleTagProvidersElegantly);
        }
        return Optional.empty();
    }

    @Override
    public List<Requirement> getAncestorRequirementsFor(TestOutcome testOutcome) {
        for (RequirementsTagProvider requirementsTagProvider : this.getRequirementsTagProviders()) {
            Optional<Requirement> requirement = this.getParentRequirementOf(testOutcome, requirementsTagProvider);
            if (!requirement.isPresent()) continue;
            LOGGER.debug("Requirement found for test outcome " + testOutcome.getTitle() + "-" + testOutcome.getIssueKeys() + ": " + requirement);
            if (this.matchingAncestorFor(requirement.get()).isPresent()) {
                Requirement matchingAncestor = this.matchingAncestorFor(requirement.get()).get();
                return this.getRequirementAncestors().get(matchingAncestor);
            }
            LOGGER.warn("Requirement without identified ancestors found test outcome " + testOutcome.getTitle() + "-" + testOutcome.getIssueKeys() + ": " + requirement);
        }
        return Collections.EMPTY_LIST;
    }

    Optional<Requirement> matchingAncestorFor(Requirement requirement) {
        return this.getRequirementAncestors().keySet().stream().filter(requirementKey -> requirementKey.matches(requirement)).findFirst();
    }

    protected void indexRequirements() {
        this.requirementAncestors = new ConcurrentHashMap<Requirement, List<Requirement>>();
        for (Requirement requirement : this.requirements) {
            List<Requirement> requirementPath = NewList.of(requirement);
            this.requirementAncestors.put(requirement, NewList.of(requirement));
            this.indexChildRequirements(requirementPath, requirement.getChildren());
        }
    }

    private void indexChildRequirements(List<Requirement> ancestors, List<Requirement> children) {
        for (Requirement requirement : children) {
            ArrayList<Requirement> requirementPath = new ArrayList<Requirement>(ancestors);
            requirementPath.add(requirement);
            this.requirementAncestors.put(requirement, NewList.copyOf(requirementPath));
            this.indexChildRequirements(requirementPath, requirement.getChildren());
        }
    }

    private ReleaseManager getReleaseManager() {
        if (this.releaseManager == null) {
            ReportNameProvider defaultNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, (RequirementsService)this);
            this.releaseManager = new ReleaseManager(this.environmentVariables, defaultNameProvider, this);
        }
        return this.releaseManager;
    }

    private Map<Requirement, List<Requirement>> getRequirementAncestors() {
        if (this.requirementAncestors == null) {
            this.getRequirements();
        }
        return this.requirementAncestors;
    }

    private Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome, RequirementsTagProvider tagProvider) {
        Optional<Requirement> parentDefinedInTags = ParentRequirementsProvided.by(tagProvider).forOutcome(testOutcome);
        if (parentDefinedInTags.isPresent()) {
            Optional<Requirement> matchingIndexedParentRequirement = this.findMatchingIndexedRequirement(parentDefinedInTags.get());
            return matchingIndexedParentRequirement;
        }
        return Optional.empty();
    }

    private Optional<Requirement> findMatchingIndexedRequirement(Requirement requirement) {
        for (Requirement indexedRequirement : AllRequirements.in(this.requirements)) {
            if (!requirement.matches(indexedRequirement)) continue;
            return Optional.of(this.mostPreciseOf(requirement, indexedRequirement));
        }
        return Optional.empty();
    }

    private Requirement mostPreciseOf(Requirement thisRequirement, Requirement thatRequirement) {
        String thisParent = thisRequirement.getParent() != null ? thisRequirement.getParent() : "";
        String thatParent = thatRequirement.getParent() != null ? thatRequirement.getParent() : "";
        return thatParent.length() >= thisParent.length() ? thatRequirement : thisRequirement;
    }

    @Override
    public List<Release> getReleasesFromRequirements() {
        if (this.releases == null) {
            if (this.getReleaseProvider().isPresent() && this.getReleaseProvider().get().isActive()) {
                this.releases = this.getReleaseProvider().get().getReleases();
            } else {
                List<List<String>> releaseVersions = this.getReleaseVersionsFrom(this.getRequirements());
                this.releases = this.getReleaseManager().extractReleasesFrom(releaseVersions);
            }
        }
        return this.releases;
    }

    public List<String> getTopLevelRequirementTypes() {
        ArrayList<String> requirementTypes = new ArrayList<String>();
        for (Requirement requirement : this.getRequirements()) {
            requirementTypes.add(requirement.getType());
        }
        return requirementTypes;
    }

    @Override
    public List<String> getRequirementTypes() {
        ArrayList<String> requirementTypes = new ArrayList<String>();
        for (String type : this.requirementTypesDefinedIn(this.getRequirements())) {
            if (requirementTypes.contains(type)) continue;
            requirementTypes.add(type);
        }
        return requirementTypes;
    }

    private Collection<String> requirementTypesDefinedIn(List<Requirement> requirements) {
        ArrayList<String> requirementTypes = new ArrayList<String>();
        for (Requirement requirement : requirements) {
            if (!requirementTypes.contains(requirement.getType())) {
                requirementTypes.add(requirement.getType());
            }
            if (requirement.getChildren().isEmpty()) continue;
            requirementTypes.addAll(this.requirementTypesDefinedIn(requirement.getChildren()));
        }
        return requirementTypes;
    }

    private Collection<TestTag> requirementTagsOfType(List<Requirement> requirements, List<String> tagTypes) {
        HashSet<TestTag> requirementTypes = new HashSet<TestTag>();
        for (Requirement requirement : AllRequirements.in(requirements)) {
            List matchingTags = requirement.getTags().stream().filter(tag -> tagTypes.contains(tag.getType())).collect(Collectors.toList());
            requirementTypes.addAll(matchingTags);
        }
        return requirementTypes;
    }

    @Override
    public List<String> getReleaseVersionsFor(TestOutcome testOutcome) {
        ArrayList<String> releases = new ArrayList<String>(testOutcome.getVersions());
        for (Requirement parentRequirement : this.getAncestorRequirementsFor(testOutcome)) {
            releases.addAll(parentRequirement.getReleaseVersions());
        }
        return releases;
    }

    private List<List<String>> getReleaseVersionsFrom(List<Requirement> requirements) {
        ArrayList<List<String>> releaseVersions = new ArrayList<List<String>>();
        for (Requirement requirement : requirements) {
            releaseVersions.add(requirement.getReleaseVersions());
            releaseVersions.addAll(this.getReleaseVersionsFrom(requirement.getChildren()));
        }
        return releaseVersions;
    }

    @Override
    public boolean isRequirementsTag(TestTag tag) {
        return this.getRequirementTypes().contains(tag.getType());
    }

    @Override
    public Collection<TestTag> getTagsOfType(List<String> tagTypes) {
        return this.requirementTagsOfType(this.getRequirements(), tagTypes);
    }
}

