/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.RootDirectory;
import net.thucydides.core.requirements.SearchForFilesOfType;
import net.thucydides.core.requirements.model.RequirementTypeAt;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RequirementsConfiguration {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = NewList.of("capability", "feature", "story");
    private static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private final EnvironmentVariables environmentVariables;
    SearchForFilesOfType jbehaveFileMatcher;
    private SearchForFilesOfType cucumberFileMatcher;

    public RequirementsConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public List<String> getRequirementTypes() {
        String requirementTypes = ThucydidesSystemProperty.SERENITY_REQUIREMENT_TYPES.from(this.environmentVariables);
        List types = StringUtils.isNotEmpty((CharSequence)requirementTypes) ? Splitter.on((String)",").trimResults().splitToList((CharSequence)requirementTypes) : this.getDefaultCapabilityTypes();
        return types;
    }

    public String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }

    public List<String> getDefaultCapabilityTypes() {
        if (this.jbehaveFilesExist()) {
            return this.jbehaveCapabilityTypes();
        }
        if (this.cucumberFilesExist()) {
            return this.cucumberCapabilityTypes();
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    private List<String> jbehaveCapabilityTypes() {
        int featureDirectoryDepth = this.getJBehaveFileMatcher().get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("story");
            }
            case 1: {
                return NewList.of("feature", "story");
            }
        }
        return NewList.of("capability", "feature", "story");
    }

    private List<String> cucumberCapabilityTypes() {
        int featureDirectoryDepth = this.getCucumberFileMatcher().get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("feature");
            }
            case 1: {
                return NewList.of("capability", "feature");
            }
        }
        return NewList.of("theme", "capability", "feature");
    }

    private Optional<SearchForFilesOfType> getJBehaveFileMatcher() {
        if (this.jbehaveFileMatcher != null) {
            return Optional.of(this.jbehaveFileMatcher);
        }
        try {
            Optional<Path> root = RootDirectory.definedIn(this.environmentVariables).featuresOrStoriesRootDirectory();
            if (root.isPresent()) {
                this.jbehaveFileMatcher = new SearchForFilesOfType(root.get(), ".story");
                Files.walkFileTree(root.get(), this.jbehaveFileMatcher);
                return Optional.of(this.jbehaveFileMatcher);
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public String getRequirementType(int level) {
        return RequirementTypeAt.level(level).in(this.getRequirementTypes());
    }

    private Optional<SearchForFilesOfType> getCucumberFileMatcher() {
        if (this.cucumberFileMatcher != null) {
            return Optional.of(this.cucumberFileMatcher);
        }
        try {
            Optional<Path> root = RootDirectory.definedIn(this.environmentVariables).featuresOrStoriesRootDirectory();
            if (root.isPresent()) {
                this.cucumberFileMatcher = new SearchForFilesOfType(root.get(), ".feature");
                Files.walkFileTree(root.get(), this.cucumberFileMatcher);
                return Optional.of(this.cucumberFileMatcher);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.empty();
    }

    private boolean jbehaveFilesExist() {
        return this.getJBehaveFileMatcher().isPresent() && this.getJBehaveFileMatcher().get().hasMatchingFiles();
    }

    private boolean cucumberFilesExist() {
        return this.getCucumberFileMatcher().isPresent() && this.getCucumberFileMatcher().get().hasMatchingFiles();
    }

    public int startLevelForADepthOf(int requirementsDepth) {
        return Math.max(0, this.getRequirementTypes().size() - requirementsDepth);
    }
}

