/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.model.TestResult;

public class ResultIconFormatter {
    private final Map<TestResult, String> resultIcons = new HashMap<TestResult, String>();
    private final Map<TestResult, String> resultIconStyles;
    private String qualifier;

    public ResultIconFormatter() {
        this.resultIcons.put(TestResult.COMPROMISED, "<i class='fa fa-chain-broken ${iconStyle} ${qualifier}' title='${result}'></i>");
        this.resultIcons.put(TestResult.ERROR, "<i class='fa fa-exclamation-triangle ${iconStyle} ${qualifier}' title='${result}'></i>");
        this.resultIcons.put(TestResult.FAILURE, "<i class='fa fa-times-circle ${iconStyle} ${qualifier}' title='${result}'></i>");
        this.resultIcons.put(TestResult.SUCCESS, "<i class='fa fa-check-circle-o ${iconStyle} ${qualifier}' title='${result}'></i>");
        this.resultIcons.put(TestResult.PENDING, "<i class='far fa-stop-circle ${iconStyle} ${qualifier}' title='${result}'></i>");
        this.resultIcons.put(TestResult.IGNORED, "<i class='fa fa-ban ${iconStyle} ${qualifier}' title='${result}'></i>");
        this.resultIcons.put(TestResult.SKIPPED, "<i class='fa fa-fast-forward ${iconStyle} ${qualifier}' title='${result}'></i>");
        this.resultIcons.put(TestResult.UNDEFINED, "");
        this.resultIconStyles = new HashMap<TestResult, String>();
        this.resultIconStyles.put(TestResult.COMPROMISED, "compromised-icon");
        this.resultIconStyles.put(TestResult.ERROR, "error-icon");
        this.resultIconStyles.put(TestResult.FAILURE, "failure-icon");
        this.resultIconStyles.put(TestResult.SUCCESS, "success-icon");
        this.resultIconStyles.put(TestResult.PENDING, "pending-icon");
        this.resultIconStyles.put(TestResult.IGNORED, "ignored-icon");
        this.resultIconStyles.put(TestResult.SKIPPED, "skipped-icon");
        this.resultIconStyles.put(TestResult.UNDEFINED, "undefined-icon");
        this.qualifier = "";
    }

    public ResultIconFormatter inLarge() {
        this.qualifier = "fa-2x";
        return this;
    }

    public ResultIconFormatter inExtraLarge() {
        this.qualifier = "fa-3x";
        return this;
    }

    public String forResult(String result) {
        return this.forResult(TestResult.valueOf(result));
    }

    public String forResult(TestResult result) {
        TestResult testResult = Optional.ofNullable(result).orElse(TestResult.PENDING);
        return this.resultIcons.get((Object)testResult).replace("${iconStyle}", this.resultIconStyles.get((Object)testResult)).replace("${qualifier}", this.qualifier).replace("${result}", testResult.toString());
    }

    public String colorFor(TestResult result) {
        return this.resultIconStyles.get((Object)Optional.ofNullable(result).orElse(TestResult.PENDING));
    }
}

