/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.classpath;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.requirements.classpath.ClassNarrative;
import net.thucydides.core.requirements.classpath.PackageInfoClass;
import net.thucydides.core.requirements.classpath.PackageInfoNarrative;
import net.thucydides.core.requirements.classpath.PathElements;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementTypeAt;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.util.NameConverter;

public class LeafRequirementAdder {
    private final String path;
    private final String rootPackage;
    private final int requirementsDepth;
    private List<String> activeRequirementTypes;
    RequirementsConfiguration requirementsConfiguration;

    public static LeafRequirementsAdderBuilder addLeafRequirementDefinedIn(String path) {
        return new LeafRequirementsAdderBuilder(path);
    }

    protected LeafRequirementAdder(String path, int requirementsDepth, String rootPackage, List<String> activeRequirementTypes) {
        this.path = path;
        this.rootPackage = rootPackage;
        this.requirementsDepth = requirementsDepth;
        this.activeRequirementTypes = activeRequirementTypes;
        this.requirementsConfiguration = new RequirementsConfiguration(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public Requirement to(Collection<Requirement> allRequirements) {
        Requirement newRequirement = PackageInfoClass.isDefinedIn(this.path) ? this.requirementDefinedByNarrativeAt(this.path, allRequirements) : this.requirementDefinedByClassNameAt(this.path);
        allRequirements.add(newRequirement);
        return newRequirement;
    }

    private Requirement requirementDefinedByClassNameAt(String path) {
        List<String> pathElements = PathElements.elementsOf(path, this.rootPackage);
        String storyName = NameConverter.humanize(PathElements.lastOf(pathElements));
        String parent = null;
        if (pathElements.size() >= 2) {
            parent = NameConverter.humanize(PathElements.secondLastOf(pathElements));
        }
        String narrativeText = PackageInfoNarrative.text().definedInPath(path).orElse(ClassNarrative.text().definedInPath(path).orElse(""));
        String narrativeType = PackageInfoNarrative.type().definedInPath(path).orElse(ClassNarrative.type().definedInPath(path).orElse(this.leafRequirementTypeFrom(pathElements)));
        Requirement story = Requirement.named(storyName).withType(narrativeType).withNarrative(narrativeText).withParent(parent).withPath(Joiner.on("/").join(PathElements.allButLast(pathElements)));
        return story;
    }

    private Requirement requirementDefinedByNarrativeAt(String path, Collection<Requirement> knownRequirements) {
        List<String> pathElements = PathElements.elementsOf(path, this.rootPackage);
        List<String> featurePathElements = PathElements.allButLast(pathElements);
        String featureName = NameConverter.humanize(PathElements.lastOf(featurePathElements));
        String parent = null;
        if (featurePathElements.size() >= 2) {
            parent = NameConverter.humanize(PathElements.secondLastOf(featurePathElements));
        }
        int startFromRequirementLevel = this.requirementsConfiguration.startLevelForADepthOf(this.requirementsDepth);
        String typeByLevel = this.requirementsConfiguration.getRequirementType(startFromRequirementLevel + featurePathElements.size() - 1);
        String type = PackageInfoNarrative.type().definedInPath(path).orElse(typeByLevel);
        Optional<Requirement> knownMatchingRequirement = this.findMatchingRequirementWithName(knownRequirements, featureName, type);
        if (knownMatchingRequirement.isPresent()) {
            knownRequirements.remove(knownMatchingRequirement);
        }
        return knownMatchingRequirement.orElse(Requirement.named(featureName).withTypeOf(type)).withNarrative(PackageInfoNarrative.text().definedInPath(path).orElse("")).withParent(parent).withPath(Joiner.on("/").join(featurePathElements));
    }

    private Optional<Requirement> findMatchingRequirementWithName(Collection<Requirement> knownRequirements, String featureName, String featureType) {
        for (Requirement requirement : knownRequirements) {
            if (!requirement.getName().equalsIgnoreCase(featureName) || !requirement.getType().equalsIgnoreCase(featureType)) continue;
            return Optional.of(requirement);
        }
        return Optional.empty();
    }

    private String leafRequirementTypeFrom(List<String> pathElements) {
        return RequirementTypeAt.level(pathElements.size() - 1).in(this.activeRequirementTypes);
    }

    public static class LeafRequirementsAdderBuilder {
        private final String path;
        private int requirementsDepth;
        private List<String> activeRequirementTypes;

        public LeafRequirementsAdderBuilder(String path) {
            this.path = path;
        }

        public LeafRequirementAdder startingAt(String rootPackage) {
            return new LeafRequirementAdder(this.path, this.requirementsDepth, rootPackage, this.activeRequirementTypes);
        }

        public LeafRequirementsAdderBuilder withAMaximumRequirementsDepthOf(int requirementsDepth) {
            this.requirementsDepth = requirementsDepth;
            return this;
        }

        public LeafRequirementsAdderBuilder usingRequirementTypes(List<String> activeRequirementTypes) {
            this.activeRequirementTypes = activeRequirementTypes;
            return this;
        }
    }
}

