/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import com.google.inject.Inject;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.LocalPreferences;
import net.thucydides.core.util.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileLocalPreferences
implements LocalPreferences {
    public static final String TYPESAFE_CONFIG_FILE = "serenity.conf";
    private File workingDirectory;
    private File homeDirectory;
    private File mavenModuleDirectory;
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileLocalPreferences.class);
    private final String PROPERTIES = ThucydidesSystemProperty.PROPERTIES.getPropertyName();

    @Inject
    public PropertiesFileLocalPreferences(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.homeDirectory = new File(System.getProperty("user.home"));
        this.workingDirectory = new File(System.getProperty("user.dir"));
        String mavenBuildDir = System.getProperty("project.build.directory");
        this.mavenModuleDirectory = !StringUtils.isEmpty((CharSequence)mavenBuildDir) ? new File(mavenBuildDir) : this.workingDirectory;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Override
    public void loadPreferences() throws IOException {
        this.updatePreferencesFrom(this.preferencesIn(this.preferencesFileWithAbsolutePath()), this.preferencesIn(this.legacyPreferencesFileWithAbsolutePath()), this.typesafeConfigPreferencesInCustomDefinedConfigFile(), this.typesafeConfigPreferences(), this.preferencesIn(this.preferencesFileInMavenModuleDirectory()), this.preferencesIn(this.preferencesFileInMavenParentModuleDirectory()), this.preferencesIn(this.preferencesFileInWorkingDirectory()), this.preferencesIn(this.legacyPreferencesFileInWorkingDirectory()), this.preferencesIn(this.preferencesFileInHomeDirectory()), this.preferencesIn(this.legacyPreferencesFileInHomeDirectory()), this.preferencesInClasspath());
    }

    private Properties preferencesInClasspath() throws IOException {
        try (InputStream propertiesOnClasspath = this.propertiesInputStream();){
            if (propertiesOnClasspath != null) {
                Properties localPreferences = new Properties();
                localPreferences.load(propertiesOnClasspath);
                Properties properties = localPreferences;
                return properties;
            }
        }
        return new Properties();
    }

    private InputStream propertiesInputStream() {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.defaultPropertiesFileName());
        if (input == null) {
            input = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.legacyPropertiesFileName());
        }
        return input;
    }

    private Properties typesafeConfigPreferencesInCustomDefinedConfigFile() {
        Optional<File> providedConfigFile = this.defaultPropertiesConfFile();
        if (!providedConfigFile.isPresent()) {
            return new Properties();
        }
        Set preferences = ConfigFactory.parseFile((File)providedConfigFile.get()).entrySet();
        return this.getPropertiesFromConfig(preferences);
    }

    private Properties typesafeConfigPreferences() {
        Optional<File> configFile = this.defaultPropertiesConfFile();
        if (configFile.isPresent()) {
            Set preferences = configFile.get().exists() ? ConfigFactory.parseFile((File)configFile.get()).entrySet() : ConfigFactory.load((String)TYPESAFE_CONFIG_FILE).entrySet();
            return this.getPropertiesFromConfig(preferences);
        }
        return new Properties();
    }

    private Properties getPropertiesFromConfig(Set<Map.Entry<String, ConfigValue>> preferences) {
        Properties properties = new Properties();
        for (Map.Entry<String, ConfigValue> preference : preferences) {
            properties.put(preference.getKey(), StringUtils.strip((String)preference.getValue().render(), (String)"\""));
        }
        return properties;
    }

    private void updatePreferencesFrom(Properties ... propertySets) throws IOException {
        for (Properties localPreferences : propertySets) {
            PropertiesUtil.expandPropertyAndEnvironmentReferences(System.getenv(), localPreferences);
            this.setUndefinedSystemPropertiesFrom(localPreferences);
        }
    }

    private Properties preferencesIn(File preferencesFile) throws IOException {
        Properties preferenceProperties = new Properties();
        if (preferencesFile.exists()) {
            try (FileInputStream preferences = new FileInputStream(preferencesFile);){
                LOGGER.debug("LOADING LOCAL PROPERTIES FROM {} ", (Object)preferencesFile.getAbsolutePath());
                preferenceProperties.load(preferences);
            }
        }
        return preferenceProperties;
    }

    private void setUndefinedSystemPropertiesFrom(Properties localPreferences) {
        Enumeration<?> propertyNames = localPreferences.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            String localPropertyValue = localPreferences.getProperty(propertyName);
            String currentPropertyValue = this.environmentVariables.getProperty(propertyName);
            if (currentPropertyValue != null || localPropertyValue == null) continue;
            LOGGER.debug(propertyName + "=" + localPropertyValue);
            this.environmentVariables.setProperty(propertyName, localPropertyValue);
        }
    }

    private File preferencesFileInHomeDirectory() {
        return new File(this.homeDirectory, this.defaultPropertiesFileName());
    }

    private File legacyPreferencesFileInHomeDirectory() {
        return new File(this.homeDirectory, this.legacyPropertiesFileName());
    }

    private File preferencesFileInWorkingDirectory() {
        return new File(this.workingDirectory, this.defaultPropertiesFileName());
    }

    private File preferencesFileInMavenModuleDirectory() {
        return new File(this.mavenModuleDirectory, this.defaultPropertiesFileName());
    }

    private File preferencesFileInMavenParentModuleDirectory() {
        File parentModuleDirectory = this.mavenModuleDirectory.getParentFile();
        return new File(parentModuleDirectory, this.defaultPropertiesFileName());
    }

    private File legacyPreferencesFileInWorkingDirectory() {
        return new File(this.workingDirectory, this.legacyPropertiesFileName());
    }

    private File preferencesFileWithAbsolutePath() {
        return new File(this.defaultPropertiesFileName());
    }

    private File legacyPreferencesFileWithAbsolutePath() {
        return new File(this.legacyPropertiesFileName());
    }

    private Optional<File> defaultPropertiesConfFile() {
        List<String> possibleConfigFileNames = Arrays.asList(this.optionalEnvironmentVariable(System.getProperty(this.PROPERTIES)).orElse("src/test/resources/serenity.conf"), "src/test/resources/serenity.conf", "src/main/resources/serenity.conf");
        return possibleConfigFileNames.stream().map(File::new).filter(File::exists).findFirst();
    }

    private String defaultPropertiesFileName() {
        return this.optionalEnvironmentVariable(System.getProperty(this.PROPERTIES)).orElse(this.optionalEnvironmentVariable(System.getenv(this.PROPERTIES)).orElse("serenity.properties"));
    }

    private String legacyPropertiesFileName() {
        return this.optionalEnvironmentVariable(System.getProperty(this.PROPERTIES)).orElse(this.optionalEnvironmentVariable(System.getenv(this.PROPERTIES)).orElse("thucydides.properties"));
    }

    private Optional<String> optionalEnvironmentVariable(String value) {
        return Optional.ofNullable(value);
    }
}

