/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.FlagsAugmenter;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeAugmenter;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.ReportLoadingFailedError;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;

public class TestOutcomeLoader {
    private final EnvironmentVariables environmentVariables;
    private final FormatConfiguration formatConfiguration;
    private static final List<? extends OutcomeAugmenter> AUGMENTERS = NewList.of(new FlagsAugmenter());

    public TestOutcomeLoader() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    @Inject
    public TestOutcomeLoader(EnvironmentVariables environmentVariables) {
        this(environmentVariables, new FormatConfiguration(environmentVariables));
    }

    private TestOutcomeLoader(EnvironmentVariables environmentVariables, FormatConfiguration formatConfiguration) {
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = formatConfiguration;
    }

    public TestOutcomeLoader forFormat(OutcomeFormat format) {
        return new TestOutcomeLoader(this.environmentVariables, new FormatConfiguration(format));
    }

    public List<TestOutcome> loadFrom(File reportDirectory) throws ReportLoadingFailedError {
        try {
            ArrayList<TestOutcomeLoaderCallable> partitions = new ArrayList<TestOutcomeLoaderCallable>();
            AcceptanceTestLoader testOutcomeReporter = this.getOutcomeReporter();
            for (File sourceFile : this.getAllOutcomeFilesFrom(reportDirectory)) {
                partitions.add(new TestOutcomeLoaderCallable(testOutcomeReporter, sourceFile));
            }
            ExecutorService executorPool = Executors.newFixedThreadPool(20);
            List loadedTestOutcomes = executorPool.invokeAll(partitions);
            ArrayList<TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
            for (Future loadedTestOutcome : loadedTestOutcomes) {
                testOutcomes.addAll((Collection)loadedTestOutcome.get());
            }
            executorPool.shutdown();
            return TestOutcomeLoader.inOrderOfTestExecution(testOutcomes);
        }
        catch (Exception e) {
            throw new ReportLoadingFailedError("Can not load reports for some reason", e);
        }
    }

    private List<File> getAllOutcomeFilesFrom(File reportsDirectory) throws IOException {
        File[] matchingFiles = reportsDirectory.listFiles(new SerializedOutcomeFilenameFilter());
        if (matchingFiles == null) {
            throw new IOException("Could not find directory " + reportsDirectory);
        }
        return NewList.copyOf(matchingFiles);
    }

    public static TestOutcomeLoaderBuilder loadTestOutcomes() {
        return new TestOutcomeLoaderBuilder();
    }

    public static TestOutcomes testOutcomesIn(File reportsDirectory) throws IOException {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        return TestOutcomes.of(loader.loadFrom(reportsDirectory));
    }

    private static List<TestOutcome> inOrderOfTestExecution(List<TestOutcome> testOutcomes) {
        return testOutcomes.stream().sorted(Comparator.comparing(TestOutcome::getStartTime, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    private AcceptanceTestLoader getOutcomeReporter() {
        switch (this.formatConfiguration.getPreferredFormat()) {
            case XML: {
                return new XMLTestOutcomeReporter();
            }
            case JSON: {
                return new JSONTestOutcomeReporter();
            }
        }
        throw new IllegalArgumentException("Unsupported report format: " + (Object)((Object)this.formatConfiguration.getPreferredFormat()));
    }

    private class SerializedOutcomeFilenameFilter
    implements FilenameFilter {
        private SerializedOutcomeFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(TestOutcomeLoader.this.formatConfiguration.getPreferredFormat().getExtension()) && !filename.endsWith(".features.json") && !filename.endsWith("manifest.json") && !filename.startsWith("SERENITY-JUNIT-");
        }
    }

    public static final class TestOutcomeLoaderBuilder {
        OutcomeFormat format;

        public TestOutcomeLoaderBuilder inFormat(OutcomeFormat format) {
            this.format = format;
            return this;
        }

        public TestOutcomes from(File reportsDirectory) throws IOException {
            TestOutcomeLoader loader = new TestOutcomeLoader().forFormat(this.format);
            return TestOutcomes.of(loader.loadFrom(reportsDirectory));
        }
    }

    class TestOutcomeLoaderCallable
    implements Callable<Set<TestOutcome>> {
        private final File sourceFile;
        private final AcceptanceTestLoader testOutcomeReporter;

        TestOutcomeLoaderCallable(AcceptanceTestLoader testOutcomeReporter, File sourceFile) {
            this.testOutcomeReporter = testOutcomeReporter;
            this.sourceFile = sourceFile;
        }

        @Override
        public Set<TestOutcome> call() throws Exception {
            Optional<TestOutcome> loadedTestOutcome = this.testOutcomeReporter.loadReportFrom(this.sourceFile);
            return loadedTestOutcome.map(Collections::singleton).orElse(Collections.emptySet()).stream().map(this::augmented).collect(Collectors.toSet());
        }

        private TestOutcome augmented(TestOutcome testOutcome) {
            AUGMENTERS.forEach(augmenter -> augmenter.augment(testOutcome));
            return testOutcome;
        }
    }
}

