/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.core.requirements.model.cucumber.ExampleTableInMarkdown;
import net.thucydides.core.requirements.model.cucumber.NamedScenario;
import net.thucydides.core.requirements.model.cucumber.ScenarioDisplayOption;
import net.thucydides.core.requirements.model.cucumber.ScenarioReport;
import net.thucydides.core.requirements.reports.cucumber.RenderCucumber;

public class IdentifiedScenario
extends NamedScenario {
    private Feature feature;
    private String scenarioReport;
    private ScenarioDefinition scenarioDefinition;
    private ExampleTableInMarkdown exampleTableInMarkdown;

    protected IdentifiedScenario(Feature feature, ScenarioDefinition scenarioDefinition) {
        this.feature = feature;
        this.scenarioReport = ScenarioReport.forScenario(scenarioDefinition.getName()).inFeature(feature);
        this.scenarioDefinition = scenarioDefinition;
        this.exampleTableInMarkdown = new ExampleTableInMarkdown(feature, this.scenarioReport, scenarioDefinition);
    }

    @Override
    public Optional<String> asGivenWhenThen() {
        return this.asGivenWhenThen(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asGivenWhenThen(ScenarioDisplayOption displayOption) {
        String renderedDescription = "";
        String suffix = "";
        if (displayOption == ScenarioDisplayOption.WithTitle) {
            renderedDescription = "**" + this.scenarioDefinition.getName() + "**  " + this.resultToken() + System.lineSeparator();
        } else {
            suffix = this.resultToken();
        }
        renderedDescription = renderedDescription + this.scenarioDefinition.getSteps().stream().map(step -> RenderCucumber.step(step) + "  ").collect(Collectors.joining(System.lineSeparator())) + suffix;
        renderedDescription = renderedDescription + System.lineSeparator() + "[<i class=\"fa fa-info-circle\"></i> More details](" + this.scenarioReport + ")" + System.lineSeparator();
        return Optional.of("" + renderedDescription + "");
    }

    private String resultToken() {
        return "{result:" + this.feature.getName() + "!" + this.scenarioDefinition.getName() + "}";
    }

    @Override
    public Optional<String> asExampleTable() {
        return this.asExampleTable(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asExampleTable(ScenarioDisplayOption withDisplayOption) {
        if (!(this.scenarioDefinition instanceof ScenarioOutline)) {
            return Optional.empty();
        }
        ScenarioOutline scenarioOutline = (ScenarioOutline)this.scenarioDefinition;
        StringBuilder renderedExamples = new StringBuilder();
        int exampleRow = 0;
        for (Examples example : scenarioOutline.getExamples()) {
            renderedExamples.append(this.exampleTableInMarkdown.renderedFormOf(example, exampleRow++, withDisplayOption));
            if (exampleRow >= scenarioOutline.getExamples().size() - 1) continue;
            renderedExamples.append(System.lineSeparator());
        }
        return Optional.of(renderedExamples.toString());
    }
}

