/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumericalFormatter {
    public String rounded(Double value, int precision) {
        DecimalFormat format = this.decimalFormatWithPrecision(precision);
        return format.format(value);
    }

    public String percentage(Double value, int precision) {
        DecimalFormat format = this.percentageFormatWithPrecision(precision);
        return format.format(value);
    }

    private DecimalFormat decimalFormatWithPrecision(int precision) {
        StringBuffer format = new StringBuffer("#");
        if (precision > 0) {
            format.append(".");
            for (int i = 0; i < precision; ++i) {
                format.append("#");
            }
        }
        return this.getDecimalFormat(format.toString());
    }

    private DecimalFormat percentageFormatWithPrecision(int precision) {
        StringBuffer format = new StringBuffer("#");
        if (precision > 0) {
            format.append(".");
            for (int i = 0; i < precision; ++i) {
                format.append("#");
            }
        }
        format.append("%");
        return this.getDecimalFormat(format.toString());
    }

    private DecimalFormat getDecimalFormat(String format) {
        DecimalFormat result = new DecimalFormat(format);
        result.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return result;
    }
}

