/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.annotations;

import com.google.common.reflect.ClassPath;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import net.thucydides.core.util.JUnitAdapter;

public class ClassInfoAnnotations {
    private final ClassPath.ClassInfo classInfo;

    public ClassInfoAnnotations(ClassPath.ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public static ClassInfoAnnotations theClassDefinedIn(ClassPath.ClassInfo classInfo) {
        return new ClassInfoAnnotations(classInfo);
    }

    public boolean hasAnAnnotation(Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (this.classInfo.load().getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasAPackageAnnotation(Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (this.classInfo.load().getPackage().getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    public boolean containsTests() {
        for (Method method : this.classInfo.load().getMethods()) {
            if (!JUnitAdapter.isTestMethod(method)) continue;
            return true;
        }
        return false;
    }
}

