/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomes;

public class RequirementsProportionCounter {
    private final TestType testType;
    private final TestOutcomes testOutcomes;
    private final long estimatedTotalTests;

    public RequirementsProportionCounter(TestType testType, TestOutcomes testOutcomes, long estimatedTotalTests) {
        this.testType = testType;
        this.testOutcomes = testOutcomes;
        this.estimatedTotalTests = estimatedTotalTests;
    }

    public Double withResult(String expectedResult) {
        return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
    }

    public Double withResult(TestResult expectedTestResult) {
        long testCount = this.testOutcomes.count(this.testType).withResult(expectedTestResult);
        return this.estimatedTotalTests == 0L ? 0.0 : (double)testCount / (double)this.estimatedTotalTests;
    }

    public Double withIndeterminateResult() {
        long passingStepCount = this.testOutcomes.count(this.testType).withResult(TestResult.SUCCESS);
        long failingStepCount = this.testOutcomes.count(this.testType).withResult(TestResult.FAILURE);
        long errorStepCount = this.testOutcomes.count(this.testType).withResult(TestResult.ERROR);
        long total = this.estimatedTotalTests;
        return total == 0L ? 0.0 : (double)(total - passingStepCount - failingStepCount - errorStepCount) / (double)total;
    }
}

