/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestOutcome;

public class ContextIcon {
    private static final Map<String, String> FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS = new HashMap<String, String>();

    public static String forOutcome(TestOutcome testOutcome) {
        String context = testOutcome.getContext();
        if (context == null) {
            return "";
        }
        return String.format("<span class='context-icon'>%s</span>", Arrays.stream(context.split(",")).map(String::trim).map(ContextIcon::iconFor).collect(Collectors.joining(" ")));
    }

    private static String iconFor(String contextName) {
        return FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.containsKey(contextName) ? String.format("<i class='fa fa-%s' aria-hidden='true'></i>", FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.get(contextName)) : contextName.toUpperCase();
    }

    static {
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("chrome", "chrome");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("firefox", "firefox");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("safari", "safari");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("opera", "opera");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("ie", "internet-explorer");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("edge", "edge");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("phantomjs", "snapchat-ghost");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("linux", "linux");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("mac", "apple");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("windows", "windows");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("android", "android");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("iphone", "apple");
        FONTAWESOME_CLASSES_FOR_COMMON_CONTEXTS.put("ios", "apple");
    }
}

