/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import com.google.common.base.Splitter;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.resource.Resource;
import io.cucumber.messages.Messages;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.html.CucumberTagConverter;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.DescriptionWithScenarioReferences;
import net.thucydides.core.requirements.model.cucumber.InvalidFeatureFileException;
import net.thucydides.core.requirements.model.cucumber.NarrativeFromCucumberComments;
import net.thucydides.core.requirements.model.cucumber.URIResource;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberParser {
    private final String locale;
    private final String encoding;
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberParser.class);
    private static final String CUCUMBER_4_FEATURE_LOADER = "cucumber.runtime.model.FeatureLoader";
    private static final String CUCUMBER_2_FEATURE_LOADER = "cucumber.runtime.model.CucumberFeature";

    public CucumberParser() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public CucumberParser(EnvironmentVariables environmentVariables) {
        this(ThucydidesSystemProperty.FEATURE_FILE_LANGUAGE.from(environmentVariables, "en"), environmentVariables);
    }

    public CucumberParser(String locale, EnvironmentVariables environmentVariables) {
        this.locale = locale;
        this.encoding = ThucydidesSystemProperty.FEATURE_FILE_ENCODING.from(environmentVariables, Charset.defaultCharset().name());
    }

    public Optional<AnnotatedFeature> loadFeature(File narrativeFile) {
        if (narrativeFile == null) {
            return Optional.empty();
        }
        if (!narrativeFile.exists()) {
            return Optional.empty();
        }
        ArrayList<String> listOfFiles = new ArrayList<String>();
        listOfFiles.add(narrativeFile.getAbsolutePath());
        List<Messages.GherkinDocument> gherkinDocuments = this.loadCucumberFeatures(listOfFiles);
        try {
            if (gherkinDocuments.size() == 0) {
                return Optional.empty();
            }
            Messages.GherkinDocument gherkinDocument = gherkinDocuments.get(0);
            String descriptionInComments = NarrativeFromCucumberComments.in(gherkinDocument.getCommentsList());
            if (this.featureFileCouldNotBeReadFor(gherkinDocument.getFeature())) {
                return Optional.empty();
            }
            List<Messages.GherkinDocument.Feature.Scenario> scenarioList = gherkinDocument.getFeature().getChildrenList().stream().filter(Messages.GherkinDocument.Feature.FeatureChild::hasScenario).map(Messages.GherkinDocument.Feature.FeatureChild::getScenario).collect(Collectors.toList());
            return Optional.of(new AnnotatedFeature(gherkinDocument.getFeature(), scenarioList, descriptionInComments));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    private List<Messages.GherkinDocument> loadCucumberFeatures(List<String> listOfFiles) {
        for (String cucumberFile : listOfFiles) {
            this.searchForCucumberSyntaxErrorsIn(cucumberFile);
        }
        ArrayList<Messages.GherkinDocument> loadedFeatures = new ArrayList<Messages.GherkinDocument>();
        List envelopes = this.getFeatures(listOfFiles).stream().flatMap(feature -> StreamSupport.stream(feature.getParseEvents().spliterator(), false)).collect(Collectors.toList());
        List gherkinDocuments = envelopes.stream().filter(o -> ((Messages.Envelope)o).hasGherkinDocument()).map(o -> ((Messages.Envelope)o).getGherkinDocument()).collect(Collectors.toList());
        for (Messages.GherkinDocument gherkinDocument : gherkinDocuments) {
            if (gherkinDocument.hasFeature()) {
                loadedFeatures.add(gherkinDocument);
                LOGGER.debug("Added feature {}", (Object)gherkinDocument.getFeature().getName());
                continue;
            }
            LOGGER.warn("Couldn't read the feature file {} - it will be ignored", (Object)gherkinDocument.getUri());
        }
        return loadedFeatures;
    }

    private void searchForCucumberSyntaxErrorsIn(String cucumberFile) {
        FeatureParser featureParser = new FeatureParser(UUID::randomUUID);
        Path cucumberFilePath = new File(cucumberFile).toPath();
        URIResource cucumberResource = new URIResource(cucumberFilePath);
        try {
            featureParser.parseResource((Resource)cucumberResource);
        }
        catch (Throwable throwable) {
            this.reportAnyCucumberSyntaxErrorsIn(throwable);
        }
    }

    private List<Feature> getFeatures(List<String> paths) {
        FeatureParser featureParser = new FeatureParser(UUID::randomUUID);
        ArrayList<Feature> results = new ArrayList<Feature>();
        paths.forEach(path -> {
            Path cucumberFilePath = new File((String)path).toPath();
            URIResource cucumberResource = new URIResource(cucumberFilePath);
            Optional maybeFeature = featureParser.parseResource((Resource)cucumberResource);
            maybeFeature.ifPresent(results::add);
        });
        return results;
    }

    private void reportAnyCucumberSyntaxErrorsIn(Throwable gherkinError) {
        if (gherkinError instanceof FeatureParserException) {
            throw new InvalidFeatureFileException(gherkinError.getMessage(), gherkinError);
        }
    }

    public Optional<Narrative> loadFeatureNarrative(File narrativeFile) {
        Optional<AnnotatedFeature> loadedFeature = this.loadFeature(narrativeFile);
        if (!loadedFeature.isPresent()) {
            return Optional.empty();
        }
        Messages.GherkinDocument.Feature feature = loadedFeature.get().getFeature();
        String cardNumber = this.findCardNumberInTags(this.tagsDefinedIn(feature));
        List<String> versionNumbers = this.findVersionNumberInTags(this.tagsDefinedIn(feature));
        String title = feature.getName();
        String text = this.descriptionWithScenarioReferencesFrom(feature);
        String id = this.getIdFromName(title);
        Set requirementTags = feature.getTagsList().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        requirementTags.add(TestTag.withName(title).andType("feature"));
        HashMap<String, Collection<TestTag>> scenarioTags = new HashMap<String, Collection<TestTag>>();
        feature.getChildrenList().forEach(child -> {
            if (child.hasScenario()) {
                Messages.GherkinDocument.Feature.Scenario scenarioDefinition = child.getScenario();
                if (scenarioDefinition.getExamplesCount() > 0) {
                    List scenarioOutlineTags = scenarioDefinition.getTagsList();
                    scenarioTags.put(scenarioDefinition.getName(), CucumberTagConverter.toSerenityTags(scenarioOutlineTags));
                    List examples = scenarioDefinition.getExamplesList();
                    for (Messages.GherkinDocument.Feature.Scenario.Examples currentExample : examples) {
                        ArrayList<Messages.GherkinDocument.Feature.Tag> allExampleTags = new ArrayList<Messages.GherkinDocument.Feature.Tag>();
                        allExampleTags.addAll(scenarioOutlineTags);
                        allExampleTags.addAll(currentExample.getTagsList());
                        scenarioTags.put(scenarioDefinition.getName() + "_examples_at_line:" + currentExample.getLocation().getLine(), CucumberTagConverter.toSerenityTags(allExampleTags));
                    }
                } else {
                    scenarioTags.put(scenarioDefinition.getName(), this.tagsFrom(scenarioDefinition));
                }
            }
        });
        List<String> scenarios = feature.getChildrenList().stream().filter(Messages.GherkinDocument.Feature.FeatureChild::hasScenario).map(Messages.GherkinDocument.Feature.FeatureChild::getScenario).map(Messages.GherkinDocument.Feature.Scenario::getName).collect(Collectors.toList());
        return Optional.of(new Narrative(Optional.ofNullable(title), Optional.ofNullable(id), Optional.ofNullable(cardNumber), versionNumbers, "feature", text != null ? text : "", new ArrayList<TestTag>(requirementTags), scenarios, scenarioTags));
    }

    private Collection<TestTag> tagsFrom(Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        if (scenarioDefinition.getExamplesCount() == 0) {
            return this.asSerenityTags(scenarioDefinition.getTagsList());
        }
        HashSet<TestTag> outlineTags = new HashSet<TestTag>(this.asSerenityTags(scenarioDefinition.getTagsList()));
        scenarioDefinition.getExamplesList().forEach(examples -> outlineTags.addAll(this.asSerenityTags(examples.getTagsList())));
        return outlineTags;
    }

    private Set<TestTag> asSerenityTags(List<Messages.GherkinDocument.Feature.Tag> gherkinTags) {
        return gherkinTags.stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private String descriptionWithScenarioReferencesFrom(Messages.GherkinDocument.Feature feature) {
        if (feature.getDescription() == null) {
            return "";
        }
        return Arrays.stream(feature.getDescription().split("\\r?\\n")).map(line -> DescriptionWithScenarioReferences.from(feature).forText((String)line)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String getIdFromName(String name) {
        return name.replaceAll("[\\s_]", "-").toLowerCase();
    }

    private boolean featureFileCouldNotBeReadFor(Messages.GherkinDocument.Feature feature) {
        return feature == null;
    }

    private List<Messages.GherkinDocument.Feature.Tag> tagsDefinedIn(Messages.GherkinDocument.Feature feature) {
        return feature.getTagsList();
    }

    private String findCardNumberInTags(List<Messages.GherkinDocument.Feature.Tag> tags) {
        for (Messages.GherkinDocument.Feature.Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@issue:")) {
                return tag.getName().replaceAll("@issue:", "");
            }
            if (!tag.getName().toLowerCase().startsWith("@issues:")) continue;
            String issueNumberList = tag.getName().replaceAll("@issues:", "");
            List issueNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)issueNumberList);
            return (String)issueNumberTags.get(0);
        }
        return null;
    }

    private List<String> findVersionNumberInTags(List<Messages.GherkinDocument.Feature.Tag> tags) {
        ArrayList<String> versionNumbers = new ArrayList<String>();
        for (Messages.GherkinDocument.Feature.Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@version:")) {
                versionNumbers.add(tag.getName().replaceAll("@version:", ""));
                continue;
            }
            if (!tag.getName().toLowerCase().startsWith("@versions:")) continue;
            String versionNumberList = tag.getName().replaceAll("@versions:", "");
            List versionNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)versionNumberList);
            versionNumbers.addAll(versionNumberTags);
        }
        return versionNumbers;
    }
}

