/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.tags.Taggable;
import org.junit.internal.AssumptionViolatedException;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;
import org.opentest4j.TestAbortedException;

public class JUnitAdapter {
    private static List<JUnitStrategy> strategies = new ArrayList<JUnitStrategy>();

    static List<JUnitStrategy> getStrategies() {
        return Collections.unmodifiableList(strategies);
    }

    public static boolean isTestClass(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return JUnitAdapter.delegateToStrategies(s -> s.isTestClass(testClass));
    }

    public static boolean isTestMethod(Method method) {
        if (method == null) {
            return false;
        }
        return JUnitAdapter.delegateToStrategies(s -> s.isTestMethod(method));
    }

    public static boolean isTestSetupMethod(Method method) {
        if (method == null) {
            return false;
        }
        return JUnitAdapter.delegateToStrategies(s -> s.isTestSetupMethod(method));
    }

    public static boolean isSerenityTestCase(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return JUnitAdapter.delegateToStrategies(s -> s.isSerenityTestCase(testClass));
    }

    public static boolean isAssumptionViolatedException(Throwable throwable) {
        return JUnitAdapter.delegateToStrategies(s -> s.isAssumptionViolatedException(throwable));
    }

    public static boolean isATaggableClass(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return JUnitAdapter.delegateToStrategies(s -> s.isATaggableClass(testClass));
    }

    public static boolean isIgnored(Method method) {
        if (method == null) {
            return false;
        }
        return JUnitAdapter.delegateToStrategies(s -> s.isIgnored(method));
    }

    private static boolean delegateToStrategies(Function<JUnitStrategy, Boolean> jUnitStrategyBooleanFunction) {
        return strategies.stream().map(jUnitStrategyBooleanFunction).filter(Boolean::booleanValue).findFirst().orElse(false);
    }

    private static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        if (JUnitAdapter.isClassPresent("org.junit.runner.RunWith")) {
            strategies.add(new JUnit4Strategy());
        }
        if (JUnitAdapter.isClassPresent("org.junit.jupiter.api.Test")) {
            strategies.add(new JUnit5Strategy());
        }
    }

    private static interface JUnitStrategy {
        public boolean isTestClass(Class<?> var1);

        public boolean isTestMethod(Method var1);

        public boolean isTestSetupMethod(Method var1);

        public boolean isSerenityTestCase(Class<?> var1);

        public boolean isAssumptionViolatedException(Throwable var1);

        public boolean isATaggableClass(Class<?> var1);

        public boolean isIgnored(Method var1);
    }

    private static class JUnit4Strategy
    implements JUnitStrategy {
        private final List<String> LEGAL_SERENITY_RUNNER_NAMES = NewList.of("SerenityRunner", "ThucydidesRunner", "SerenityParameterizedRunner", "ThucydidesParameterizedRunner");

        private JUnit4Strategy() {
        }

        @Override
        public boolean isTestClass(Class<?> testClass) {
            return this.containsAnnotationCalled(testClass.getAnnotations(), "RunWith");
        }

        private boolean containsAnnotationCalled(Annotation[] annotations, String annotationName) {
            return Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals(annotationName));
        }

        @Override
        public boolean isTestMethod(Method method) {
            return this.containsAnnotationCalled(method.getAnnotations(), "Test");
        }

        @Override
        public boolean isTestSetupMethod(Method method) {
            return this.containsAnnotationCalled(method.getAnnotations(), "Before") || this.containsAnnotationCalled(method.getAnnotations(), "BeforeClass");
        }

        @Override
        public boolean isSerenityTestCase(Class<?> testClass) {
            RunWith runWithAnnotation = testClass.getAnnotation(RunWith.class);
            if (runWithAnnotation != null) {
                return this.LEGAL_SERENITY_RUNNER_NAMES.contains(runWithAnnotation.value().getSimpleName());
            }
            return false;
        }

        @Override
        public boolean isAssumptionViolatedException(Throwable throwable) {
            return throwable instanceof AssumptionViolatedException;
        }

        @Override
        public boolean isATaggableClass(Class<?> testClass) {
            RunWith runWith = testClass.getAnnotation(RunWith.class);
            return runWith != null && Taggable.class.isAssignableFrom(runWith.value());
        }

        @Override
        public boolean isIgnored(Method method) {
            Annotation[] annotations = method.getAnnotations();
            return Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals("Ignore"));
        }
    }

    private static class JUnit5Strategy
    implements JUnitStrategy {
        private JUnit5Strategy() {
        }

        @Override
        public boolean isTestClass(Class<?> testClass) {
            for (Method method : testClass.getDeclaredMethods()) {
                if (!this.isTestMethod(method)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isTestMethod(Method method) {
            return method.getAnnotation(Test.class) != null;
        }

        @Override
        public boolean isTestSetupMethod(Method method) {
            return method.getAnnotation(BeforeEach.class) != null || method.getAnnotation(BeforeAll.class) != null;
        }

        @Override
        public boolean isSerenityTestCase(Class<?> testClass) {
            return this.hasSerenityAnnotation(testClass, new HashSet());
        }

        @Override
        public boolean isIgnored(Method method) {
            return Arrays.stream(method.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getName().contains("Disabled"));
        }

        private boolean hasSerenityAnnotation(Class<?> clazz, Set<Class<?>> checked) {
            checked.add(clazz);
            return Arrays.stream(clazz.getAnnotations()).anyMatch(a -> this.carriesSerenityExtension((Annotation)a, checked));
        }

        private boolean carriesSerenityExtension(Annotation annotation, Set<Class<?>> checked) {
            if (annotation instanceof ExtendWith) {
                return Arrays.stream(((ExtendWith)annotation).value()).anyMatch(c -> c.getSimpleName().matches("Serenity.*Extension"));
            }
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.getPackage().getName().startsWith("java.lang") || checked.contains(annotation.annotationType())) {
                return false;
            }
            return this.hasSerenityAnnotation(annotation.annotationType(), checked);
        }

        private String valueOf(Annotation annotation) {
            try {
                Method value = annotation.getClass().getMethod("value", new Class[0]);
                return value.invoke((Object)annotation, new Object[0]).toString();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return "";
            }
        }

        private boolean hasValueMethod(Annotation annotation) {
            try {
                return annotation.getClass().getMethod("value", new Class[0]) != null;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        @Override
        public boolean isAssumptionViolatedException(Throwable throwable) {
            return throwable instanceof TestAbortedException;
        }

        @Override
        public boolean isATaggableClass(Class<?> testClass) {
            return false;
        }
    }
}

