/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.buildinfo;

import com.google.common.base.Splitter;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.serenitybdd.core.buildinfo.BuildProperties;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfoProvider {
    private final EnvironmentVariables environmentVariables;
    private final DriverCapabilityRecord driverCapabilityRecord;
    private final Map<String, Map<String, String>> sections;
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildInfoProvider.class);
    private Binding binding;

    public BuildInfoProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.driverCapabilityRecord = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
        this.sections = new HashMap<String, Map<String, String>>();
    }

    public BuildProperties getBuildProperties() {
        HashMap<String, String> generalProperties = new HashMap<String, String>();
        generalProperties.put("Default Driver", ThucydidesSystemProperty.DRIVER.from(this.environmentVariables, "firefox"));
        generalProperties.put("Operating System", System.getProperty("os.name") + " version " + System.getProperty("os.version"));
        this.addRemoteDriverPropertiesTo(generalProperties);
        this.addSaucelabsPropertiesTo(generalProperties);
        this.addCustomPropertiesTo(generalProperties);
        Map<String, Properties> driverPropertiesMap = this.driverCapabilityRecord.getDriverCapabilities();
        return new BuildProperties(generalProperties, this.driverCapabilityRecord.getDrivers(), driverPropertiesMap, this.sections);
    }

    private void addRemoteDriverPropertiesTo(Map<String, String> buildProperties) {
        if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.isDefinedIn(this.environmentVariables)) {
            buildProperties.put("Remote driver", ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables));
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables) != null) {
                buildProperties.put("Remote browser version", ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables) != null) {
                buildProperties.put("Remote OS", ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables));
            }
        }
    }

    private void addSaucelabsPropertiesTo(Map<String, String> buildProperties) {
        if (ThucydidesSystemProperty.SAUCELABS_DATACENTER.isDefinedIn(this.environmentVariables)) {
            buildProperties.put("Saucelabs URL", this.maskAPIKey(ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.from(this.environmentVariables)));
            if (ThucydidesSystemProperty.SAUCELABS_USER_ID.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs user", ThucydidesSystemProperty.SAUCELABS_USER_ID.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs target platform", ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.SAUCELABS_BROWSER_VERSION.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs browser version", ThucydidesSystemProperty.SAUCELABS_BROWSER_VERSION.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables) != null) {
                buildProperties.put("Remote OS", ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables));
            }
        }
    }

    private String maskAPIKey(String url) {
        if (url.contains("@")) {
            int apiKeyStart = url.indexOf(":");
            int apiKeyEnd = url.indexOf("@");
            return url.substring(0, apiKeyStart + 3) + "XXXXXXXXXXXXXXXX" + url.substring(apiKeyEnd);
        }
        return url;
    }

    private void addCustomPropertiesTo(Map<String, String> buildProperties) {
        List sysInfoKeys = this.environmentVariables.getKeys().stream().filter(key -> key.startsWith("sysinfo.")).collect(Collectors.toList());
        for (String key2 : sysInfoKeys) {
            String value;
            String simplifiedKey = key2.replace("sysinfo.", "");
            String expression = EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty(key2).orElse(null);
            String string = value = this.isGroovyExpression(expression) ? this.evaluateGroovyExpression(key2, expression) : expression;
            if (this.isInASection(simplifiedKey)) {
                String sectionKey = this.humanizedFormOf(this.sectionKeyFrom(simplifiedKey));
                String fieldKey = this.humanizedFormOf(this.sectionLabelFrom(simplifiedKey));
                Map sectionValues = this.sections.getOrDefault(sectionKey, new HashMap());
                sectionValues.put(fieldKey, value);
                this.sections.put(sectionKey, sectionValues);
                continue;
            }
            buildProperties.put(this.humanizedFormOf(simplifiedKey), value);
        }
    }

    private String sectionKeyFrom(String simplifiedKey) {
        return (String)Splitter.on((String)".").splitToList((CharSequence)simplifiedKey).get(0);
    }

    private String sectionLabelFrom(String simplifiedKey) {
        return (String)Splitter.on((String)".").splitToList((CharSequence)simplifiedKey).get(1);
    }

    private boolean isInASection(String simplifiedKey) {
        return simplifiedKey.contains(".");
    }

    private boolean isGroovyExpression(String expression) {
        return expression.startsWith("${") && expression.endsWith("}");
    }

    private String humanizedFormOf(String simplifiedKey) {
        return StringUtils.strip((String)StringUtils.capitalize((String)StringUtils.replace((String)simplifiedKey, (String)".", (String)" ").replace("_", " ")), (String)"\"");
    }

    private Binding groovyBinding() {
        this.binding = new Binding();
        this.binding.setVariable("env", this.environmentVariables.asMap());
        return this.binding;
    }

    private String evaluateGroovyExpression(String key, String expression) {
        GroovyShell shell = new GroovyShell(this.groovyBinding());
        Object result = null;
        try {
            String groovy = expression.substring(2, expression.length() - 1);
            if (StringUtils.isNotEmpty((CharSequence)groovy)) {
                result = shell.evaluate(groovy);
            }
        }
        catch (GroovyRuntimeException e) {
            String error = String.format("Failed to evaluate build info expression '%s' for key '%s'", expression, key);
            LOGGER.warn(error);
        }
        return result != null ? result.toString() : expression;
    }
}

