/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import com.google.common.base.Splitter;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.exceptions.UnrecognisedException;
import net.thucydides.core.model.TestFailureException;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class FailureCause {
    public static final String ERROR_MESSAGE_LABEL_1 = "{'errorMessage':";
    public static final String ERROR_MESSAGE_LABEL_2 = "{\"errorMessage\":";
    private static final List<String> COLLAPSE_NEW_LINE_HINTS = Arrays.asList("AssertionError", "Expected", "Expecting", "ComparisonFailure");
    private String errorType;
    private String message;
    private StackTraceElement[] stackTrace;
    private FailureCause rootCause;
    private transient Throwable originalCause;

    public FailureCause() {
    }

    public FailureCause(Throwable cause) {
        this.errorType = FailureCause.exceptionClassName(cause);
        this.message = cause.getMessage();
        this.stackTrace = cause.getStackTrace();
        this.originalCause = cause;
        this.rootCause = this.rootCauseOf(cause);
    }

    private FailureCause rootCauseOf(Throwable cause) {
        if (cause.getCause() == null || cause.getCause() == cause) {
            return null;
        }
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(cause.getCause().getStackTrace());
        return new FailureCause(cause.getCause(), stackTraceSanitizer.getSanitizedStackTrace());
    }

    public FailureCause(Throwable cause, StackTraceElement[] stackTrace) {
        this(cause, FailureCause.exceptionClassName(cause), cause.getMessage(), stackTrace);
    }

    public FailureCause(Throwable cause, String exceptionClassName, String message, StackTraceElement[] stackTrace) {
        this.errorType = exceptionClassName;
        this.message = message;
        this.stackTrace = stackTrace;
        this.originalCause = cause;
        this.rootCause = this.rootCauseOf(cause);
    }

    private static String exceptionClassName(Throwable cause) {
        if (cause instanceof SerenityManagedException) {
            return ((SerenityManagedException)cause).getExceptionClass().getName();
        }
        return cause.getClass().getName();
    }

    public FailureCause(String errorType, String message, StackTraceElement[] stackTrace) {
        this.errorType = errorType;
        this.message = this.parseErrorMessage(message);
        this.stackTrace = stackTrace == null ? null : Arrays.copyOf(stackTrace, stackTrace.length);
    }

    private String parseErrorMessage(String message) {
        if (message != null && (message.startsWith(ERROR_MESSAGE_LABEL_1) || message.startsWith(ERROR_MESSAGE_LABEL_2))) {
            return this.extractErrorMessageTextFrom(message);
        }
        return message;
    }

    private String extractErrorMessageTextFrom(String message) {
        int endOfMessage = (message = message.substring(ERROR_MESSAGE_LABEL_1.length() + 1)).indexOf("','");
        if (endOfMessage == -1) {
            endOfMessage = message.indexOf("\",\"");
        }
        if (endOfMessage > 0) {
            return message.substring(0, endOfMessage);
        }
        return message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public Optional<FailureCause> getRootCause() {
        return Optional.ofNullable(this.rootCause);
    }

    public Throwable getOriginalCause() {
        return this.originalCause;
    }

    public String getSimpleErrorType() {
        return NameConverter.humanize(this.lastElementOf(Splitter.on((String)".").splitToList((CharSequence)this.errorType)));
    }

    private String lastElementOf(List<String> elements) {
        return elements.get(elements.size() - 1);
    }

    public String getMessage() {
        return this.message;
    }

    public String asString() {
        return StringUtils.isEmpty((CharSequence)this.message) ? this.errorType : this.message;
    }

    public StackTraceElement[] getStackTrace() {
        return Arrays.copyOf(this.stackTrace, this.stackTrace.length);
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = Arrays.copyOf(stackTrace, stackTrace.length);
    }

    public Class<? extends Throwable> exceptionClass() {
        try {
            return Class.forName(this.errorType);
        }
        catch (ClassNotFoundException e) {
            return Throwable.class;
        }
    }

    public String toString() {
        return "FailureCause{errorType='" + this.errorType + '\'' + ", message='" + this.message + '\'' + ", stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }

    public Throwable toException() {
        Optional<? extends Throwable> exception = this.restoreExceptionFrom(this.errorType, this.message);
        if (exception.isPresent()) {
            return exception.get();
        }
        return new TestFailureException(this.errorType + ":" + this.message);
    }

    private Optional<? extends Throwable> restoreExceptionFrom(String testFailureClassname, String testFailureMessage) {
        try {
            Class<?> failureClass = Class.forName(testFailureClassname);
            Object exception = this.buildThrowable(testFailureMessage, failureClass);
            if (exception == null) {
                exception = new UnrecognisedException();
            }
            ((Throwable)exception).setStackTrace(this.getStackTrace());
            return Optional.ofNullable(exception);
        }
        catch (Exception e) {
            UnrecognisedException exception = new UnrecognisedException();
            exception.setStackTrace(this.getStackTrace());
            return Optional.ofNullable(exception);
        }
    }

    private <T extends Throwable> T buildThrowable(String testFailureMessage, Class failureClass) throws Exception {
        if (this.stringConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)this.stringConstructorFor(failureClass).get().newInstance(testFailureMessage));
        }
        if (this.stringThrowableConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)this.stringThrowableConstructorFor(failureClass).get().newInstance(testFailureMessage, null));
        }
        if (this.throwableConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)this.throwableConstructorFor(failureClass).get().newInstance(new AssertionError((Object)testFailureMessage)));
        }
        if (AssertionError.class.isAssignableFrom(failureClass)) {
            return (T)new AssertionError((Object)testFailureMessage);
        }
        if (this.defaultConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)this.defaultConstructorFor(failureClass).get().newInstance(new Object[0]));
        }
        return null;
    }

    private Optional<Constructor> defaultConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.ofNullable(failureClass.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private Optional<Constructor> stringConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.ofNullable(failureClass.getConstructor(String.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private Optional<Constructor> stringThrowableConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.ofNullable(failureClass.getConstructor(String.class, Throwable.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private Optional<Constructor> throwableConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.ofNullable(failureClass.getConstructor(Throwable.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public String getShortenedMessage() {
        if (this.message == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)this.message.trim())) {
            return this.message;
        }
        String[] messageLines = this.withCollapedAssertionError(this.message).trim().split("\n|\n\r|\r");
        return messageLines[0];
    }

    private String withCollapedAssertionError(String message) {
        if (this.shouldCollapseAssertionsFor(message)) {
            return message.replace("\r\n", "").replace("\\r\\n", "").replace("/r/n", "").replace("\n", "").replace("\\n", "").replace("/n", "").replace("     ", " ").replace("java.lang.AssertionError", "");
        }
        return message;
    }

    private boolean shouldCollapseAssertionsFor(String message) {
        for (String collapseHint : COLLAPSE_NEW_LINE_HINTS) {
            if (!message.toLowerCase().contains(collapseHint.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Throwable asException() {
        return this.getOriginalCause();
    }
}

