/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TestResult {
    UNSUCCESSFUL(6, true, "Unsuccessful"),
    COMPROMISED(5, true, "Compromised"),
    ERROR(4, true, "Broken"),
    FAILURE(3, true, "Failing"),
    ABORTED(2, false, "Aborted"),
    SKIPPED(2, false, "Skipped"),
    IGNORED(2, false, "Ignored"),
    PENDING(2, false, "Pending"),
    SUCCESS(1, true, "Passing"),
    UNDEFINED(0, false, "Undefined");

    private final int priority;
    private final boolean executedResultsCount;
    private final String adjective;
    private static Logger logger;

    private TestResult(int priority, boolean executedResultsCount, String adjective) {
        this.priority = priority;
        this.executedResultsCount = executedResultsCount;
        this.adjective = adjective;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean overrides(TestResult result) {
        return this.priority > result.priority;
    }

    public boolean isMoreSevereThan(TestResult otherResult) {
        return this.ordinal() > otherResult.ordinal();
    }

    public boolean isLessSevereThan(TestResult otherResult) {
        return this.ordinal() < otherResult.ordinal();
    }

    public String getLabel() {
        return this.adjective + " tests";
    }

    public static boolean existsWithName(String expectedResult) {
        try {
            TestResult.valueOf(expectedResult);
        }
        catch (IllegalArgumentException noMatchingEnumValue) {
            logger.warn("No matching test result value found for {}", (Object)expectedResult);
            return false;
        }
        return true;
    }

    public boolean isAtLeast(TestResult minimumTestResult) {
        return this.priority >= minimumTestResult.priority;
    }

    public boolean executedResultsCount() {
        return this.executedResultsCount;
    }

    public String getAdjective() {
        return this.adjective;
    }

    static {
        logger = LoggerFactory.getLogger((String)"net.thucydides.core.model.TestResult");
    }
}

