/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.adapters;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.adapters.MultiStrategyAdapter;
import net.thucydides.core.adapters.TestStrategyAdapter;
import net.thucydides.core.reflection.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestFramework.class);
    private static TestStrategyAdapter selectedTestStrategyAdapter;

    public static TestStrategyAdapter support() {
        return selectedTestStrategyAdapter;
    }

    private static Optional<TestStrategyAdapter> newInstanceOf(Class<?> adaptorClass) {
        try {
            TestStrategyAdapter adapter = (TestStrategyAdapter)adaptorClass.newInstance();
            if (adapter.priority() > 0.0) {
                return Optional.of(adapter);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Cannot instantiate test framework adapter class " + adaptorClass, (Throwable)e);
        }
        return Optional.empty();
    }

    static {
        List<Class<?>> testStrategies = ClassFinder.loadClasses().thatImplement(TestStrategyAdapter.class).fromPackage("net.thucydides.core.adapters");
        ArrayList<TestStrategyAdapter> availableStrategies = new ArrayList<TestStrategyAdapter>();
        for (Class<?> strategyClass : testStrategies) {
            TestFramework.newInstanceOf(strategyClass).ifPresent(availableStrategies::add);
        }
        availableStrategies.sort((o1, o2) -> o2.priority().compareTo(o1.priority()));
        selectedTestStrategyAdapter = availableStrategies.size() > 1 ? new MultiStrategyAdapter(availableStrategies) : (TestStrategyAdapter)availableStrategies.get(0);
    }
}

