/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.BaseRequirementsService;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.PackageAnnotationBasedTagProvider;
import net.thucydides.core.requirements.ReleaseProvider;
import net.thucydides.core.requirements.RequirementAncestry;
import net.thucydides.core.requirements.RequirementsMerger;
import net.thucydides.core.requirements.RequirementsProvided;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.statistics.service.AnnotationBasedTagProvider;
import net.thucydides.core.statistics.service.FeatureStoryTagProvider;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSourceRequirementsService
extends BaseRequirementsService
implements RequirementsService {
    private List<RequirementsTagProvider> requirementsTagProviders;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private static final List<String> LOW_PRIORITY_PROVIDERS = NewList.of(FileSystemRequirementsTagProvider.class.getCanonicalName(), PackageAnnotationBasedTagProvider.class.getCanonicalName(), AnnotationBasedTagProvider.class.getCanonicalName(), FeatureStoryTagProvider.class.getCanonicalName());

    public MultiSourceRequirementsService() {
        super((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    @Override
    public List<Requirement> getRequirements() {
        RequirementsMerger merger = new RequirementsMerger();
        if (this.requirements == null || this.requirements.isEmpty()) {
            this.requirements = new ArrayList();
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                LOGGER.trace("Reading requirements from " + tagProvider);
                this.requirements = merger.merge(this.requirements, RequirementsProvided.by(tagProvider));
            }
            this.requirements = RequirementAncestry.addParentsTo(this.requirements);
            this.indexRequirements();
        }
        return this.requirements;
    }

    @Override
    public Optional<ReleaseProvider> getReleaseProvider() {
        List<RequirementsTagProvider> requirementsTagProviders = this.getRequirementsTagProviders();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (!(provider instanceof ReleaseProvider) || !((ReleaseProvider)((Object)provider)).isActive()) continue;
            return Optional.of((ReleaseProvider)((Object)provider));
        }
        return Optional.empty();
    }

    public List<RequirementsTagProvider> getRequirementsTagProviders() {
        if (this.requirementsTagProviders == null) {
            RequirementsProviderService requirementsProviderService = (RequirementsProviderService)Injectors.getInjector().getInstance(RequirementsProviderService.class);
            this.requirementsTagProviders = this.reprioritizeProviders(this.active(requirementsProviderService.getRequirementsProviders()));
        }
        return this.requirementsTagProviders;
    }

    private List<RequirementsTagProvider> active(List<RequirementsTagProvider> requirementsProviders) {
        boolean useDirectoryBasedRequirements = ThucydidesSystemProperty.THUCYDIDES_USE_REQUIREMENTS_DIRECTORIES.booleanFrom(this.environmentVariables, true);
        if (useDirectoryBasedRequirements) {
            return requirementsProviders;
        }
        ArrayList<RequirementsTagProvider> activeRequirementsProviders = new ArrayList<RequirementsTagProvider>();
        for (RequirementsTagProvider provider : requirementsProviders) {
            if (provider instanceof FileSystemRequirementsTagProvider) continue;
            activeRequirementsProviders.add(provider);
        }
        return activeRequirementsProviders;
    }

    private List<RequirementsTagProvider> reprioritizeProviders(List<RequirementsTagProvider> requirementsTagProviders) {
        HashMap<String, RequirementsTagProvider> lowPriorityProviders = new HashMap<String, RequirementsTagProvider>();
        ArrayList<RequirementsTagProvider> prioritizedProviders = new ArrayList<RequirementsTagProvider>();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (LOW_PRIORITY_PROVIDERS.contains(provider.getClass().getCanonicalName())) {
                lowPriorityProviders.put(provider.getClass().getCanonicalName(), provider);
                continue;
            }
            prioritizedProviders.add(provider);
        }
        this.addLowPriorityProviders(lowPriorityProviders, prioritizedProviders);
        return prioritizedProviders;
    }

    private void addLowPriorityProviders(Map<String, RequirementsTagProvider> lowPriorityProviders, List<RequirementsTagProvider> prioritizedProviders) {
        for (String lowPriorityProvider : LOW_PRIORITY_PROVIDERS) {
            if (!lowPriorityProviders.containsKey(lowPriorityProvider)) continue;
            prioritizedProviders.add(lowPriorityProviders.get(lowPriorityProvider));
        }
    }
}

