/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.util.EnvironmentVariables;

public class TagExclusions {
    private final EnvironmentVariables environmentVariables;
    private final List<String> excludedTags;
    private final List<String> ALWAYS_HIDDEN_TAGS = Arrays.asList("manual-result", "manual-test-evidence", "manual-last-tested", "singlebrowser");

    public TagExclusions(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.excludedTags = new ArrayList<String>(EnvironmentSpecificConfiguration.from(environmentVariables).getListOfValues(ThucydidesSystemProperty.SERENITY_REPORT_EXCLUDE_TAGS));
        this.excludedTags.addAll(EnvironmentSpecificConfiguration.from(environmentVariables).getListOfValues(ThucydidesSystemProperty.HIDDEN_TAGS));
        this.excludedTags.addAll(this.ALWAYS_HIDDEN_TAGS);
    }

    public static TagExclusions usingEnvironment(EnvironmentVariables environmentVariables) {
        return new TagExclusions(environmentVariables);
    }

    public boolean doNotExclude(TestTag tag) {
        return this.excludedTags.stream().noneMatch(excludedTag -> this.matches(tag, (String)excludedTag));
    }

    private boolean matches(TestTag tag, String excludedTag) {
        if (tag.equals(TestTag.withValue(excludedTag))) {
            return true;
        }
        if (excludedTag.endsWith(":*")) {
            String tagType = excludedTag.replace(":*", "");
            return tag.getType().equals(tagType);
        }
        if (excludedTag.startsWith("*:")) {
            String tagValue = excludedTag.replace("*:", "");
            return tag.getName().equals(tagValue);
        }
        return false;
    }
}

