/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Splitter;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.AllRequirements;
import net.thucydides.core.requirements.DisabledRequirementsStore;
import net.thucydides.core.requirements.FileSystemRequirementsStore;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementTypesProvider;
import net.thucydides.core.requirements.RequirementsList;
import net.thucydides.core.requirements.RequirementsStore;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.annotations.ClassInfoAnnotations;
import net.thucydides.core.requirements.classpath.LeafRequirementAdder;
import net.thucydides.core.requirements.classpath.NonLeafRequirementsAdder;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageRequirementsTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider,
RequirementTypesProvider {
    private final EnvironmentVariables environmentVariables;
    private String rootPackage;
    private List<Requirement> requirements;
    private final RequirementsStore requirementsStore;
    List<String> requirementPaths;
    private static final Logger logger = LoggerFactory.getLogger(PackageRequirementsTagProvider.class);
    private final List<Requirement> NO_REQUIREMENTS = new ArrayList<Requirement>();
    private final Lock readingPaths = new ReentrantLock();
    private static final ConcurrentMap<String, ScanResult> SCAN_RESULT_CACHE = new ConcurrentHashMap<String, ScanResult>();

    public PackageRequirementsTagProvider(EnvironmentVariables environmentVariables, String rootPackage, RequirementsStore requirementsStore) {
        super(environmentVariables);
        this.environmentVariables = environmentVariables;
        this.rootPackage = rootPackage;
        this.requirementsStore = requirementsStore;
    }

    public PackageRequirementsTagProvider(EnvironmentVariables environmentVariables, String rootPackage) {
        this(environmentVariables, rootPackage, StringUtils.isEmpty((CharSequence)rootPackage) ? new DisabledRequirementsStore() : new FileSystemRequirementsStore(PackageRequirementsTagProvider.getRequirementsDirectory(ConfiguredEnvironment.getConfiguration().getOutputDirectory()), rootPackage + "-package-requirements.json"));
    }

    public PackageRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this(environmentVariables, ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables));
    }

    public PackageRequirementsTagProvider() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public void clear() {
        this.requirementsStore.clear();
    }

    public PackageRequirementsTagProvider withCacheDisabled() {
        return new PackageRequirementsTagProvider(this.environmentVariables, this.rootPackage, new DisabledRequirementsStore());
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.resolvedRootPackage() == null) {
            return this.NO_REQUIREMENTS;
        }
        if (this.requirements == null) {
            this.fetchRequirements();
        }
        return this.requirements;
    }

    private String resolvedRootPackage() {
        if (this.rootPackage == null && this.environmentVariables.aValueIsDefinedFor(ThucydidesSystemProperty.SERENITY_TEST_ROOT)) {
            this.rootPackage = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(this.environmentVariables);
        }
        return this.rootPackage;
    }

    private void fetchRequirements() {
        logger.debug("Loading requirements from package requirements at: " + this.resolvedRootPackage());
        this.requirements = this.reloadedRequirements().orElse(this.requirementsReadFromClasspath().orElse(this.NO_REQUIREMENTS));
    }

    private Optional<List<Requirement>> reloadedRequirements() {
        try {
            return this.requirementsStore.read();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private Optional<List<Requirement>> requirementsReadFromClasspath() {
        ArrayList<Requirement> classpathRequirements = null;
        try {
            List<String> requirementPaths = this.requirementPathsStartingFrom(this.resolvedRootPackage());
            int requirementsDepth = this.longestPathIn(requirementPaths);
            Set<Requirement> allRequirements = new HashSet<Requirement>();
            for (String path : requirementPaths) {
                this.addRequirementsDefinedIn(path, requirementsDepth, allRequirements);
            }
            if (!(allRequirements = this.removeChildrenFromTopLevelRequirementsIn(allRequirements)).isEmpty()) {
                classpathRequirements = new ArrayList<Requirement>(allRequirements);
                Collections.sort(classpathRequirements);
                this.requirementsStore.write(classpathRequirements);
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return Optional.ofNullable(classpathRequirements);
    }

    private Comparator<? super String> byDescendingPackageLength() {
        return (o1, o2) -> {
            Integer o1Length = Splitter.on((String)".").splitToList((CharSequence)o1).size();
            Integer o2Length = Splitter.on((String)".").splitToList((CharSequence)o2).size();
            return o1Length.compareTo(o2Length);
        };
    }

    private List<String> requirementPathsStartingFrom(String rootPackage) {
        if (StringUtils.isEmpty((CharSequence)rootPackage)) {
            return new ArrayList<String>();
        }
        if (this.requirementPaths == null) {
            this.readingPaths.lock();
            List<String> paths = this.requirementPathsFromClassesInPackage(rootPackage);
            paths.sort(this.byDescendingPackageLength());
            this.requirementPaths = NewList.copyOf(paths);
            this.readingPaths.unlock();
        }
        return this.requirementPaths;
    }

    private List<String> requirementPathsFromClassesInPackage(String rootPackage) {
        Set<Class> allClassesRecursive = this.findAllClassesUsingReflectionsLibrary(rootPackage);
        List<String> classRequirementNames = allClassesRecursive.stream().filter(this::classRepresentsARequirementIn).map(Class::getName).map(className -> className.replaceAll("\\$", ".")).collect(Collectors.toList());
        classRequirementNames.addAll(this.findPackagesWithNarrativeAnnotationIn(rootPackage));
        classRequirementNames.addAll(this.findClassesWithNarrativeAnnotationIn(rootPackage));
        return classRequirementNames;
    }

    private Set<Class> findAllClassesUsingReflectionsLibrary(String packageName) {
        if (!SCAN_RESULT_CACHE.containsKey(packageName)) {
            SCAN_RESULT_CACHE.putIfAbsent(packageName, new ClassGraph().enableAllInfo().acceptPackages(new String[]{packageName}).scan());
        }
        ScanResult scanResult = (ScanResult)SCAN_RESULT_CACHE.get(packageName);
        return scanResult.getAllClasses().stream().map(classInfo -> classInfo.loadClass(true)).collect(Collectors.toSet());
    }

    private Set<String> findPackagesWithNarrativeAnnotationIn(String packageName) {
        if (!SCAN_RESULT_CACHE.containsKey(packageName)) {
            SCAN_RESULT_CACHE.putIfAbsent(packageName, new ClassGraph().enableAllInfo().acceptPackages(new String[]{packageName}).scan());
        }
        ScanResult scanResult = (ScanResult)SCAN_RESULT_CACHE.get(packageName);
        return this.narrativePackagesIn(scanResult.getPackageInfo(packageName));
    }

    private Set<String> narrativePackagesIn(PackageInfo parentPackage) {
        HashSet<String> narrativePackages = new HashSet<String>();
        if (parentPackage.hasAnnotation(Narrative.class)) {
            narrativePackages.add(parentPackage.getName());
        }
        for (PackageInfo childPackage : parentPackage.getChildren()) {
            narrativePackages.addAll(this.narrativePackagesIn(childPackage));
        }
        return narrativePackages;
    }

    private Set<String> findClassesWithNarrativeAnnotationIn(String packageName) {
        if (!SCAN_RESULT_CACHE.containsKey(packageName)) {
            SCAN_RESULT_CACHE.putIfAbsent(packageName, new ClassGraph().enableAllInfo().acceptPackages(new String[]{packageName}).scan());
        }
        ScanResult scanResult = (ScanResult)SCAN_RESULT_CACHE.get(packageName);
        return scanResult.getPackageInfo().stream().filter(packageInfo -> packageInfo.hasAnnotation(Narrative.class)).map(PackageInfo::getName).collect(Collectors.toSet());
    }

    private boolean classRepresentsARequirementIn(Class classInfo) {
        return ClassInfoAnnotations.theClassDefinedIn(classInfo).hasAnAnnotation(Narrative.class) || ClassInfoAnnotations.theClassDefinedIn(classInfo).containsTests();
    }

    private Set<Requirement> removeChildrenFromTopLevelRequirementsIn(Set<Requirement> allRequirements) {
        HashSet<Requirement> prunedRequirements = new HashSet<Requirement>();
        for (Requirement requirement : allRequirements) {
            if (requirement.getParent() != null) continue;
            prunedRequirements.add(requirement);
        }
        return prunedRequirements;
    }

    private int longestPathIn(List<String> requirementPaths) {
        int maxDepth = 0;
        for (String path : requirementPaths) {
            String pathWithoutRootPackage = path.replace(this.resolvedRootPackage() + ".", "");
            int pathDepth = Splitter.on((String)".").splitToList((CharSequence)pathWithoutRootPackage).size();
            if (pathDepth <= maxDepth) continue;
            maxDepth = pathDepth;
        }
        return Math.min(maxDepth, this.requirementsConfiguration.getRequirementTypes().size());
    }

    private void addRequirementsDefinedIn(String path, int requirementsDepth, Collection<Requirement> allRequirements) {
        Requirement leafRequirement = LeafRequirementAdder.addLeafRequirementDefinedIn(path).withAMaximumRequirementsDepthOf(requirementsDepth).usingRequirementTypes(this.getActiveRequirementTypes()).startingAt(this.resolvedRootPackage()).to(allRequirements);
        NonLeafRequirementsAdder.addParentsOf(leafRequirement).in(path).withAMaximumRequirementsDepthOf(requirementsDepth).startingAt(this.resolvedRootPackage()).to(allRequirements);
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        return this.getTestCaseRequirementOf(testOutcome);
    }

    public Optional<Requirement> getTestCaseRequirementOf(TestOutcome testOutcome) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.asTag().isAsOrMoreSpecificThan(testOutcome.getUserStory().asTag())).findFirst();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        Optional<Requirement> matching = AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.asTag().isAsOrMoreSpecificThan(testTag)).findFirst();
        if (matching.isPresent()) {
            return matching;
        }
        return this.uniqueRequirementWithName(testTag.getName());
    }

    private Optional<Requirement> uniqueRequirementWithName(String name) {
        return RequirementsList.of(this.getRequirements()).findByUniqueName(name);
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() == null) {
            return new HashSet<TestTag>();
        }
        HashSet<TestTag> tags = new HashSet<TestTag>();
        Optional<Requirement> matchingRequirement = this.getRequirementFor(testOutcome.getUserStory().asTag());
        if (matchingRequirement.isPresent()) {
            tags.add(matchingRequirement.get().asTag());
            Optional<Requirement> parent = this.parentOf(matchingRequirement.get());
            while (parent.isPresent()) {
                tags.add(parent.get().asTag());
                parent = this.parentOf(parent.get());
            }
        }
        return tags;
    }

    private Optional<Requirement> parentOf(Requirement child) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getChildren().contains(child)).findFirst();
    }

    private static File getRequirementsDirectory(File directory) {
        return new File(directory, "requirements");
    }

    public void clearCache() {
        this.requirementsStore.clear();
    }

    @Override
    public List<String> getActiveRequirementTypes() {
        List<String> allRequirementTypes = this.requirementsConfiguration.getRequirementTypes();
        int maxDepth = this.longestPathIn(this.requirementPathsStartingFrom(this.resolvedRootPackage()));
        return this.applicableRequirements(allRequirementTypes, maxDepth);
    }

    private List<String> applicableRequirements(List<String> allRequirementTypes, int maxDepth) {
        int startingLevel = Math.max(allRequirementTypes.size() - maxDepth, 0);
        int endingLevel = allRequirementTypes.size();
        return allRequirementTypes.subList(startingLevel, endingLevel);
    }
}

