/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import java.io.File;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.Rule;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.CucumberTagConverter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.requirements.reports.ReportBadges;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.requirements.reports.ScenarioOutcome;
import net.thucydides.core.requirements.reports.ScenarioSummaryOutcome;
import net.thucydides.core.requirements.reports.cucumber.RenderCucumber;
import net.thucydides.core.tags.TagScanner;
import net.thucydides.core.util.EnvironmentVariables;

public class FeatureFileScenarioOutcomes {
    private final Requirement requirement;
    private final EnvironmentVariables environmentVariables;
    private final TagScanner tagScanner;

    public FeatureFileScenarioOutcomes(Requirement requirement, EnvironmentVariables environmentVariables) {
        this.requirement = requirement;
        this.environmentVariables = environmentVariables;
        this.tagScanner = new TagScanner(environmentVariables);
    }

    public FeatureFileScenarioOutcomes(Requirement requirement) {
        this(requirement, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public static FeatureFileScenarioOutcomes from(Requirement requirement) {
        return new FeatureFileScenarioOutcomes(requirement);
    }

    private String normalizedFormOf(String path) {
        return path.replace("\\", "/");
    }

    public List<ScenarioOutcome> forOutcomesIn(RequirementsOutcomes requirementsOutcomes) {
        CucumberParser parser = new CucumberParser();
        Optional<AnnotatedFeature> feature = parser.loadFeature(this.pathFromResourceOnClasspath(this.normalizedFormOf(this.requirement.getPath())));
        if (!feature.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<ScenarioOutcome> scenarioOutcomes = new ArrayList<ScenarioOutcome>();
        Feature currentFeature = feature.get().getFeature();
        for (FeatureChild currentChild : currentFeature.getChildren()) {
            if (currentChild.getRule() != null) {
                io.cucumber.messages.types.Rule currentRule = currentChild.getRule();
                currentRule.getChildren().stream().filter(ruleChild -> ruleChild.getScenario() != null).forEach(ruleChild -> scenarioOutcomes.add(this.scenarioOutcomeFrom(currentFeature, ruleChild.getScenario(), requirementsOutcomes.getTestOutcomes(), Rule.from(currentRule))));
                continue;
            }
            if (currentChild.getScenario() != null) {
                scenarioOutcomes.add(this.scenarioOutcomeFrom(currentFeature, currentChild.getScenario(), requirementsOutcomes.getTestOutcomes()));
            }
            if (currentChild.getBackground() == null) continue;
            scenarioOutcomes.add(this.scenarioBackgroundFrom(currentFeature, currentChild.getBackground(), requirementsOutcomes.getTestOutcomes()));
        }
        return scenarioOutcomes;
    }

    private ScenarioOutcome scenarioOutcomeFrom(Feature feature, Scenario scenario, TestOutcomes testOutcomes) {
        return this.scenarioOutcomeFrom(feature, scenario, testOutcomes, null);
    }

    private ScenarioOutcome scenarioBackgroundFrom(Feature feature, Background scenario, TestOutcomes testOutcomes) {
        List<TestOutcome> outcomes = testOutcomes.testOutcomesWithName(scenario.getName());
        String scenarioTitle = scenario.getName();
        TestResult result = outcomes.isEmpty() ? TestResult.UNDEFINED : TestResultList.overallResultFrom(outcomes.stream().map(TestOutcome::getResult).collect(Collectors.toList()));
        List<String> reportBadges = ReportBadges.from(outcomes, scenario.getName());
        String featureReport = new ReportNameProvider().forRequirement(feature.getName(), "feature");
        Optional<String> scenarioReport = outcomes.isEmpty() ? Optional.empty() : Optional.of(outcomes.get(0).getHtmlReport());
        List<String> renderedSteps = scenario.getSteps().stream().map(RenderCucumber::step).collect(Collectors.toList());
        return new ScenarioSummaryOutcome(scenarioTitle, scenario.getKeyword(), result, reportBadges, scenarioReport.orElse(""), scenario.getDescription(), renderedSteps, new ArrayList<String>(), 0, false, feature.getName(), featureReport, new HashSet<TestTag>(), new HashMap<String, Collection<TestTag>>(), null, this.startTimeOfFirstTestIn(outcomes), this.totalDurationOf(outcomes));
    }

    private ZonedDateTime startTimeOfFirstTestIn(List<TestOutcome> outcomes) {
        return outcomes.stream().map(TestOutcome::getStartTime).sorted().findFirst().orElse(null);
    }

    private Long totalDurationOf(List<TestOutcome> outcomes) {
        return outcomes.stream().mapToLong(TestOutcome::getDuration).sum();
    }

    private ScenarioOutcome scenarioOutcomeFrom(Feature feature, Scenario scenario, TestOutcomes testOutcomes, Rule rule) {
        List<TestOutcome> outcomes = testOutcomes.testOutcomesWithName(scenario.getName());
        String scenarioTitle = scenario.getName();
        TestResult result = outcomes.isEmpty() ? TestResult.UNDEFINED : TestResultList.overallResultFrom(outcomes.stream().map(TestOutcome::getResult).collect(Collectors.toList()));
        List<String> reportBadges = ReportBadges.from(outcomes, scenario.getName());
        String featureReport = new ReportNameProvider().forRequirement(feature.getName(), "feature");
        Optional<String> scenarioReport = outcomes.isEmpty() ? Optional.empty() : Optional.of(outcomes.get(0).getHtmlReport());
        List<String> renderedSteps = scenario.getSteps().stream().map(RenderCucumber::step).collect(Collectors.toList());
        ArrayList<Examples> filteredExamples = new ArrayList<Examples>();
        HashMap<String, Collection<TestTag>> exampleTags = new HashMap<String, Collection<TestTag>>();
        if (this.scenarioContainsExamples(scenario)) {
            List examples2 = scenario.getExamples();
            examples2.stream().filter(example -> example.getTags().isEmpty() || this.tagScanner.shouldRunForTags(CucumberTagConverter.fromGherkinTags(example.getTags()))).forEach(filteredExamples::add);
            Set<TestTag> scenarioOutlineTags = this.scenarioOutlineTagsIn(scenario);
            examples2.forEach(example -> {
                Collection<TestTag> testTags = CucumberTagConverter.toSerenityTags(example.getTags());
                testTags.addAll(scenarioOutlineTags);
                exampleTags.put(example.getName() + ":" + example.getLocation(), testTags);
            });
        }
        ArrayList<String> renderedExamples = this.scenarioContainsExamples(scenario) ? RenderCucumber.examples(filteredExamples, feature.getName()) : new ArrayList();
        int exampleCount = this.scenarioContainsExamples(scenario) ? filteredExamples.stream().mapToInt(examples -> examples.getTableBody().size()).sum() : 0;
        Boolean isManual = outcomes.size() == 1 ? outcomes.get(0).isManual() : this.hasManualTag(feature.getTags()).booleanValue();
        Set<TestTag> scenarioTags = outcomes.stream().flatMap(outcome -> outcome.getTags().stream()).collect(Collectors.toSet());
        scenarioTags.addAll(this.scenarioTagsDefinedIn(scenario));
        return new ScenarioSummaryOutcome(scenarioTitle, scenario.getKeyword(), result, reportBadges, scenarioReport.orElse(""), scenario.getDescription(), renderedSteps, renderedExamples, exampleCount, isManual, feature.getName(), featureReport, scenarioTags, exampleTags, rule, this.startTimeOfFirstTestIn(outcomes), this.totalDurationOf(outcomes));
    }

    private Set<TestTag> scenarioTagsDefinedIn(Scenario scenario) {
        if (this.scenarioContainsExamples(scenario)) {
            return this.scenarioOutlineTagsIncludingExamplesIn(scenario);
        }
        return this.scenarioTagsIn(scenario);
    }

    private boolean scenarioContainsExamples(Scenario scenario) {
        return !scenario.getExamples().isEmpty();
    }

    private Set<TestTag> scenarioOutlineTagsIn(Scenario scenarioOutline) {
        return scenarioOutline.getTags().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private Set<TestTag> scenarioOutlineTagsIncludingExamplesIn(Scenario scenarioOutline) {
        Set<TestTag> testTags = this.scenarioOutlineTagsIn(scenarioOutline);
        Set exampleTags = scenarioOutline.getExamples().stream().flatMap(examples -> examples.getTags().stream()).map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        testTags.addAll(exampleTags);
        return testTags;
    }

    private Set<TestTag> scenarioTagsIn(Scenario scenario) {
        return scenario.getTags().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private Boolean hasManualTag(List<Tag> tags) {
        return tags.stream().anyMatch(tag -> tag.getName().toLowerCase().startsWith("@manual"));
    }

    private File pathFromResourceOnClasspath(String path) {
        URL featureFileURL = this.getClass().getClassLoader().getResource(this.featuresDirectory() + "/" + path);
        String featureFilePath = featureFileURL != null ? featureFileURL.getFile() : new File("src/test/resources/" + this.featuresDirectory() + "/" + path).getAbsolutePath();
        return featureFilePath == null ? null : new File(featureFilePath);
    }

    private String featuresDirectory() {
        return ThucydidesSystemProperty.SERENITY_FEATURES_DIRECTORY.from(this.environmentVariables, "features");
    }
}

