/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomes;

public class ResultCounts {
    private TestOutcomes testOutcomes;
    private final Map<TestResult, Integer> automatedTests = new HashMap<TestResult, Integer>();
    private final Map<TestResult, Integer> manualTests = new HashMap<TestResult, Integer>();
    private final Map<TestResult, Integer> totalTests = new HashMap<TestResult, Integer>();
    private final int totalAutomatedTests;
    private final int totalManualTests;
    private final int totalTestCount;

    public ResultCounts(TestOutcomes testOutcomes) {
        this.testOutcomes = testOutcomes;
        for (TestResult result : TestResult.values()) {
            this.automatedTests.put(result, testOutcomes.ofType(TestType.AUTOMATED).scenarioCountWithResult(result));
            this.manualTests.put(result, testOutcomes.ofType(TestType.MANUAL).scenarioCountWithResult(result));
            this.totalTests.put(result, this.automatedTests.get((Object)result) + this.manualTests.get((Object)result));
        }
        this.totalAutomatedTests = testOutcomes.ofType(TestType.AUTOMATED).getTotal();
        this.totalManualTests = testOutcomes.ofType(TestType.MANUAL).getTotal();
        this.totalTestCount = testOutcomes.getTotal();
    }

    public boolean hasManualTests() {
        return this.manualTests.values().stream().anyMatch(value -> value > 0);
    }

    public Integer getAutomatedTestCount(String result) {
        return this.automatedTests.getOrDefault((Object)TestResult.valueOf(result.toUpperCase()), 0);
    }

    public Integer getManualTestCount(String result) {
        return this.manualTests.getOrDefault((Object)TestResult.valueOf(result.toUpperCase()), 0);
    }

    public Integer getOverallTestCount(String result) {
        return this.totalTests.getOrDefault((Object)TestResult.valueOf(result.toUpperCase()), 0);
    }

    public Integer getOverallTestsCount(String ... results) {
        int allTestsCount = 0;
        for (String result : results) {
            allTestsCount += this.getOverallTestCount(result).intValue();
        }
        return allTestsCount;
    }

    public Integer getTotalAutomatedTestCount() {
        return this.totalAutomatedTests;
    }

    public Integer getTotalManualTestCount() {
        return this.totalManualTests;
    }

    public Integer getTotalOverallTestCount() {
        return this.totalTestCount;
    }

    public String getAutomatedTestPercentageLabel(String result) {
        return this.percentageLabelFor(this.getAutomatedTestPercentage(result).intValue());
    }

    public String getManualTestPercentageLabel(String result) {
        return this.percentageLabelFor(this.getManualTestPercentage(result).intValue());
    }

    public String getOverallTestPercentageLabel(String result) {
        return this.percentageLabelFor(this.getOverallTestPercentage(result).intValue());
    }

    public Integer getAutomatedTestPercentage(String result) {
        return (int)Math.round((double)this.getAutomatedTestCount(result).intValue() * 100.0 / (double)this.totalTestCount);
    }

    public Integer getManualTestPercentage(String result) {
        return (int)Math.round((double)this.getManualTestCount(result).intValue() * 100.0 / (double)this.totalTestCount);
    }

    public Integer getOverallTestPercentage(String result) {
        return (int)Math.round((double)this.getOverallTestCount(result).intValue() * 100.0 / (double)this.totalTestCount);
    }

    public Double getPreciseTestPercentage(String result) {
        return (double)this.getOverallTestCount(result).intValue() * 100.0 / (double)this.totalTestCount;
    }

    public static ResultCounts forOutcomesIn(TestOutcomes testOutcomes) {
        return new ResultCounts(testOutcomes);
    }

    public String byTypeFor(String ... testResultTypes) {
        ArrayList<String> resultCounts = new ArrayList<String>();
        for (String resultType : testResultTypes) {
            resultCounts.add(this.labeledValue(resultType, TestType.ANY));
        }
        return Arrays.toString(resultCounts.toArray());
    }

    public String allResultValuesFor(String ... testResultTypes) {
        return "[" + Arrays.stream(testResultTypes).map(this::getOverallTestCount).map(value -> Integer.toString(value)).collect(Collectors.joining(",")) + "]";
    }

    public String automatedResultValuesFor(String ... testResultTypes) {
        return "[" + Arrays.stream(testResultTypes).map(this::getAutomatedTestCount).map(value -> Integer.toString(value)).collect(Collectors.joining(",")) + "]";
    }

    public String manualResultValuesFor(String ... testResultTypes) {
        return "[" + Arrays.stream(testResultTypes).map(this::getManualTestCount).map(value -> Integer.toString(value)).collect(Collectors.joining(",")) + "]";
    }

    private String labeledValue(String resultType, TestType testType) {
        int resultCount = testType == TestType.AUTOMATED ? this.getAutomatedTestCount(resultType) : (testType == TestType.MANUAL ? this.getManualTestCount(resultType).intValue() : this.getOverallTestCount(resultType).intValue());
        String label = TestResult.valueOf(resultType.toUpperCase()).getLabel();
        if (testType != TestType.ANY) {
            label = label + " (" + testType.toString().toLowerCase() + ")";
        }
        return "{meta: '" + label + "', value: " + resultCount + "}";
    }

    public String percentageLabelsByTypeFor(String ... testResultTypes) {
        ArrayList<String> resultLabels = new ArrayList<String>();
        int totalTestCount = this.testOutcomes.getTestCount();
        for (String resultType : testResultTypes) {
            double percentageAutomated = (double)this.automatedTests.get((Object)TestResult.valueOf(resultType.toUpperCase())).intValue() * 100.0 / (double)totalTestCount;
            double percentageManual = (double)this.manualTests.get((Object)TestResult.valueOf(resultType.toUpperCase())).intValue() * 100.0 / (double)totalTestCount;
            resultLabels.add("'" + this.percentageLabelFor(percentageAutomated) + "'");
            resultLabels.add("'" + this.percentageLabelFor(percentageManual) + "'");
        }
        return Arrays.toString(resultLabels.toArray());
    }

    private String percentageLabelFor(double value) {
        return value > 0.0 ? Math.round(value) + "%" : " ";
    }
}

