/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.formatters;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.formatters.IssueExtractor;
import net.thucydides.core.util.EnvironmentVariables;

public class ReportFormatter {
    private static final String ISSUE_LINK_FORMAT = "<a target=\"_blank\" href=\"{0}\">{1}</a>";
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;

    public ReportFormatter() {
        this((IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public ReportFormatter(IssueTracking issueTracking, EnvironmentVariables environmentVariables) {
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
    }

    public ReportFormatter(IssueTracking issueTracking) {
        this(issueTracking, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public static List<String> issuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        List<String> issuesWithHash = extractor.getShortenedIssues();
        List<String> allIssues = extractor.getFullIssues();
        allIssues.addAll(issuesWithHash);
        return allIssues;
    }

    public String stripQualifications(String title) {
        if (title == null) {
            return "";
        }
        if (title.contains("[")) {
            return title.substring(0, title.lastIndexOf("[")).trim();
        }
        return title;
    }

    public String addLinks(String value) {
        if (this.issueTracking == null) {
            return value;
        }
        String formattedValue = value;
        if (this.issueTracking.getIssueTrackerUrl() != null) {
            formattedValue = this.insertFullIssueTrackingUrls(value);
        }
        if (this.issueTracking.getShortenedIssueTrackerUrl() != null) {
            formattedValue = this.insertShortenedIssueTrackingUrls(formattedValue);
        }
        return formattedValue;
    }

    public String asIssueLink(String issueNumber) {
        if (this.issueTracking == null || this.issueTracking.getIssueTrackerUrl() == null) {
            return issueNumber;
        }
        return this.issueTracking.getIssueTrackerUrl().replace("{0}", issueNumber);
    }

    private String insertShortenedIssueTrackingUrls(String value) {
        String issueUrlFormat = this.issueTracking.getShortenedIssueTrackerUrl();
        List<String> issues = this.sortByDecreasingSize(ReportFormatter.shortenedIssuesIn(value));
        String formattedValue = this.replaceWithTokens(value, issues);
        int i = 0;
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, this.stripLeadingHashFrom(issue));
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            String token = "%%%" + i++ + "%%%";
            formattedValue = formattedValue.replaceAll(token, issueLink);
        }
        return formattedValue;
    }

    private String insertFullIssueTrackingUrls(String value) {
        String issueUrlFormat = this.issueTracking.getIssueTrackerUrl();
        List<String> issues = this.sortByDecreasingSize(ReportFormatter.fullIssuesIn(value));
        String formattedValue = this.replaceWithTokens(value, issues);
        int i = 0;
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, issue);
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            String token = "%%%" + i++ + "%%%";
            formattedValue = formattedValue.replaceAll(token, issueLink);
        }
        return formattedValue;
    }

    private List<String> sortByDecreasingSize(List<String> issues) {
        ArrayList<String> sortedIssues = new ArrayList<String>(issues);
        Collections.sort(sortedIssues, (a, b) -> Integer.valueOf(-a.length()).compareTo(b.length()));
        return sortedIssues;
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }

    public static List<String> fullIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getFullIssues();
    }

    public static List<String> shortenedIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getShortenedIssues();
    }

    private String replaceWithTokens(String value, List<String> issues) {
        List<String> sortedIssues = this.inOrderOfDecreasingLength(issues);
        for (int i = 0; i < sortedIssues.size(); ++i) {
            value = value.replaceAll(sortedIssues.get(i), "%%%" + i + "%%%");
        }
        return value;
    }

    private List<String> inOrderOfDecreasingLength(List<String> issues) {
        List<String> sortedIssues = NewList.copyOf(issues);
        Collections.sort(sortedIssues, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return sortedIssues;
    }
}

