/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.adapters.TestFramework;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.configuration.SystemPropertiesConfiguration;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementPersister;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.SerenityTestCaseFinder;
import net.thucydides.core.requirements.annotations.NarrativeFinder;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;

public class PackageAnnotationBasedTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider {
    private static final String DOT_REGEX = "\\.";
    private static final List<String> SUPPORTED_SUFFIXES = NewList.of("story", "feature");
    private final Configuration configuration = new SystemPropertiesConfiguration(this.environmentVariables);
    private final RequirementPersister persister;
    private String rootPackage = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(this.environmentVariables, this.rootDirectory);
    SortedMap<String, Requirement> requirementsByPath = null;

    public PackageAnnotationBasedTagProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public PackageAnnotationBasedTagProvider(EnvironmentVariables vars) {
        super(vars);
        this.persister = new RequirementPersister(this.getRequirementsDirectory(), this.rootPackage);
    }

    private File getRequirementsDirectory() {
        return new File(this.configuration.getOutputDirectory(), "requirements");
    }

    @Override
    public List<Requirement> getRequirements() {
        return NewList.copyOf(this.rootRequirementsIn(this.getRequirementsByPath().values()));
    }

    Map<Requirement, String> getRequirementPaths() {
        HashMap<Requirement, String> requirementPaths = new HashMap<Requirement, String>();
        for (String path : this.getRequirementsByPath().keySet()) {
            requirementPaths.put(this.getRequirementsByPath().get(path), path);
        }
        return requirementPaths;
    }

    private List<Requirement> rootRequirementsIn(Collection<Requirement> allRequirements) {
        ArrayList<Requirement> rootRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : allRequirements) {
            if (requirement.getParent() != null) continue;
            rootRequirements.add(requirement);
        }
        return rootRequirements;
    }

    private Map<String, Requirement> getRequirementsByPath() {
        if (this.requirementsByPath == null) {
            this.requirementsByPath = this.loadRequirementsByPath();
        }
        return this.requirementsByPath;
    }

    private SortedMap<String, Requirement> loadRequirementsByPath() {
        List<Class<?>> classes = this.loadClassesFromPath();
        return classes.isEmpty() ? this.loadPersistedRequirements() : this.loadRequirementsFromClasses(classes);
    }

    private SortedMap<String, Requirement> loadPersistedRequirements() {
        try {
            return this.persister.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new TreeMap<String, Requirement>();
        }
    }

    private SortedMap<String, Requirement> loadRequirementsFromClasses(List<Class<?>> classes) {
        TreeMap<String, Requirement> requirementMap = new TreeMap<String, Requirement>();
        int maxDepth = this.maximumClassDepth(classes, this.rootPackage);
        for (Class<?> candidateClass : classes) {
            this.addRequirementTo(requirementMap, candidateClass, maxDepth);
        }
        this.addChildrenTo(requirementMap);
        this.persistRequirementsAsJSON(requirementMap);
        return requirementMap;
    }

    private void addChildrenTo(SortedMap<String, Requirement> requirementsByPath) {
        Set<String> paths = requirementsByPath.keySet();
        for (String path : paths) {
            Requirement requirement = (Requirement)requirementsByPath.get(path);
            List<Requirement> childRequirements = this.directChildrenOf(requirement).in(requirementsByPath.values());
            requirement.setChildren(childRequirements);
        }
    }

    private RequirementChildLocator directChildrenOf(Requirement requirement) {
        return new RequirementChildLocator(requirement);
    }

    private void addRequirementTo(Map<String, Requirement> requirementsByPath, Class<?> candidateClass, int maxDepth) {
        String fullRequirementName = this.getFullRequirementPath(candidateClass);
        String[] packageNames = fullRequirementName.split(DOT_REGEX);
        String currentPath = "";
        Requirement parentRequirement = null;
        for (int level = 0; level < packageNames.length; ++level) {
            Requirement currentRequirement;
            currentPath = currentPath.isEmpty() ? packageNames[level] : Joiner.on(".").join(currentPath, packageNames[level]);
            String defaultRequirementType = this.getDefaultType(level, maxDepth);
            if (requirementsByPath.containsKey(currentPath)) {
                currentRequirement = requirementsByPath.get(currentPath);
            } else if (level < packageNames.length - 1) {
                currentRequirement = this.newParentRequirement(currentPath, parentRequirement, packageNames[level], level, defaultRequirementType);
                requirementsByPath.put(currentPath, currentRequirement);
            } else {
                currentRequirement = this.newRequirement(candidateClass, currentPath, parentRequirement, packageNames[level], level, defaultRequirementType);
                String fullPath = this.getFullRequirementPath(candidateClass);
                requirementsByPath.put(fullPath, currentRequirement);
            }
            parentRequirement = currentRequirement;
        }
    }

    private String getFullRequirementPath(Class candidateClass) {
        return candidateClass.getName().replace(this.rootPackage + ".", "").replace(".package-info", "");
    }

    private int maximumClassDepth(List<Class<?>> classes, String rootPackage) {
        int maxDepth = 0;
        for (Class<?> candidateClass : classes) {
            int pathDepth = this.pathDepth(rootPackage, candidateClass.getPackage().getName());
            maxDepth = Math.max(pathDepth, maxDepth);
        }
        return maxDepth;
    }

    private int pathDepth(String rootPackage, String path) {
        int maxDepth = 0;
        if (path.startsWith(rootPackage)) {
            String localPath = path.replace(rootPackage, "");
            maxDepth = StringUtils.split((String)localPath, (String)".").length;
        }
        return maxDepth;
    }

    private Requirement newParentRequirement(String requirementPath, Requirement parentRequirement, String packageName, int level, String defaultRequirementType) {
        String requirementTitle = packageName;
        String requirementType = defaultRequirementType;
        String narrativeText = "";
        String cardNumber = "";
        Class<?> candidateClass = null;
        Optional<Narrative> narrative = Optional.empty();
        try {
            candidateClass = Class.forName(this.rootPackage + "." + requirementPath + ".package-info");
            narrative = NarrativeFinder.forClass(candidateClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Requirement newRequirement = this.getRequirement(candidateClass, packageName, level, requirementTitle, requirementType, narrativeText, cardNumber, narrative);
        if (parentRequirement != null) {
            newRequirement = newRequirement.withParent(parentRequirement.getName());
        }
        return newRequirement;
    }

    private Requirement newRequirement(Class candidateClass, String currentPath, Requirement parentRequirement, String packageName, int level, String defaultRequirementType) {
        String requirementTitle = packageName;
        String requirementType = defaultRequirementType;
        String narrativeText = "";
        String cardNumber = "";
        Optional<Narrative> narrative = NarrativeFinder.forClass(candidateClass);
        Requirement newRequirement = this.getRequirement(candidateClass, packageName, level, requirementTitle, requirementType, narrativeText, cardNumber, narrative);
        if (parentRequirement != null) {
            newRequirement = newRequirement.withParent(parentRequirement.getName());
        }
        return newRequirement;
    }

    private Requirement getRequirement(Class<?> candidateClass, String packageName, int level, String requirementTitle, String requirementType, String narrativeText, String cardNumber, Optional<Narrative> narrative) {
        if (narrative.isPresent()) {
            requirementTitle = StringUtils.isNotEmpty((CharSequence)narrative.get().title()) ? narrative.get().title() : requirementTitle;
            requirementType = StringUtils.isNotEmpty((CharSequence)narrative.get().type()) ? narrative.get().type() : requirementType;
            narrativeText = narrative.get().text().length > 0 ? Joiner.on("\n").join(narrative.get().text()) : narrativeText;
            String string = cardNumber = StringUtils.isNotEmpty((CharSequence)narrative.get().cardNumber()) ? narrative.get().cardNumber() : cardNumber;
        }
        if (StringUtils.isEmpty((CharSequence)requirementType)) {
            requirementType = this.getRequirementType(level, candidateClass);
        }
        return Requirement.named(this.humanReadableVersionOf(packageName)).withOptionalCardNumber(cardNumber).withOptionalDisplayName(StringUtils.isEmpty((CharSequence)requirementTitle) ? this.humanReadableVersionOf(packageName) : this.humanReadableVersionOf(requirementTitle)).withType(requirementType).withNarrative(narrativeText);
    }

    private String getRequirementType(int level, Class<?> candidateClass) {
        if (candidateClass != null && candidateClass.getName().endsWith(".package-info")) {
            return this.getDefaultType(level);
        }
        return "story";
    }

    private void persistRequirementsAsJSON(SortedMap<String, Requirement> requirementsByPath) {
        try {
            this.persister.write(requirementsByPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() == null || testOutcome.getUserStory().getStoryClassName() == null) {
            return Optional.empty();
        }
        String name = testOutcome.getUserStory().getStoryClassName().replace(this.rootPackage + ".", "");
        return Optional.ofNullable(this.getRequirementsByPath().get(name));
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        Optional<Requirement> result = Optional.empty();
        for (Requirement requirement : this.getRequirements()) {
            if (!requirement.matchesTag(testTag)) continue;
            return Optional.of(requirement);
        }
        return result;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> result = new HashSet<TestTag>();
        for (Requirement requirement : this.getAllRequirements()) {
            if (!this.isMatchingRequirementFor(testOutcome, requirement)) continue;
            result.add(requirement.asTag());
        }
        return result;
    }

    protected List<Class<?>> loadClassesFromPath() {
        HashSet classesWithNarratives = new HashSet(ClassFinder.loadClasses().annotatedWith(Narrative.class).fromPackage(this.rootPackage));
        HashSet testCases = new HashSet(ClassFinder.loadClasses().thatMatch(clazz -> TestFramework.support().isTestClass((Class<?>)clazz)).fromPackage(this.rootPackage));
        HashSet requirementClasses = new HashSet();
        requirementClasses.addAll(classesWithNarratives);
        requirementClasses.addAll(this.classesThatContainSerenityTestsIn(testCases));
        return NewList.copyOf(requirementClasses);
    }

    private Set<? extends Class<?>> classesThatContainSerenityTestsIn(Set<Class<?>> testCases) {
        HashSet matchingClasses = new HashSet();
        SerenityTestCaseFinder serenityTestCaseFinder = new SerenityTestCaseFinder();
        for (Class<?> testClass : testCases) {
            if (!serenityTestCaseFinder.isSerenityTestCase(testClass)) continue;
            matchingClasses.add(testClass);
        }
        return matchingClasses;
    }

    private Collection<Requirement> getAllRequirements() {
        return this.getRequirementsByPath().values();
    }

    private boolean isMatchingRequirementFor(TestOutcome testOutcome, Requirement requirement) {
        if (testOutcome.getTestCase() != null) {
            return this.fullPathOf(requirement).matchesOrIsADescendantOf(this.normalizedPath(testOutcome.getPathId()));
        }
        return this.fullPathOf(requirement).matchesOrIsADescendantOf(this.normalizedPath(testOutcome.getPath()));
    }

    private String normalizedPath(String path) {
        path = path == null ? "" : path.replaceAll("/", ".");
        for (String supportedSuffix : SUPPORTED_SUFFIXES) {
            if (!path.endsWith("." + supportedSuffix)) continue;
            path = path.substring(0, path.lastIndexOf("." + supportedSuffix));
        }
        if (!path.startsWith(this.rootPackage)) {
            path = this.rootPackage + "." + path;
        }
        return path;
    }

    private RequirementPathMatcher fullPathOf(Requirement requirement) {
        return new RequirementPathMatcher(requirement);
    }

    private class RequirementPathMatcher {
        String requirementPath;

        public RequirementPathMatcher(Requirement requirement) {
            this.requirementPath = PackageAnnotationBasedTagProvider.this.rootPackage + "." + PackageAnnotationBasedTagProvider.this.getRequirementPaths().get(requirement);
        }

        public boolean matchesOrIsADescendantOf(String path) {
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                return path.startsWith(this.requirementPath) || this.requirementPath.startsWith(path);
            }
            return false;
        }
    }

    private static class RequirementChildLocator {
        Requirement parent;

        public RequirementChildLocator(Requirement parent) {
            this.parent = parent;
        }

        public List<Requirement> in(Collection<Requirement> requirements) {
            ArrayList<Requirement> children = new ArrayList<Requirement>();
            for (Requirement requirement : requirements) {
                if (!StringUtils.isNotEmpty((CharSequence)requirement.getParent()) || !requirement.getParent().equals(this.parent.getName())) continue;
                children.add(requirement);
            }
            return children;
        }
    }
}

