/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.collect.NewSet;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.model.formatters.ReportFormatter;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.RequirementsFilter;
import net.thucydides.core.requirements.ExcludedUnrelatedRequirementTypes;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.PercentageRequirementCounter;
import net.thucydides.core.requirements.reports.RequirementsPercentageFormatter;
import net.thucydides.core.requirements.reports.RequirementsProportionCounter;
import net.thucydides.core.requirements.reports.SubrequirementsCount;
import net.thucydides.core.util.EnvironmentVariables;

public class RequirementOutcome {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;
    private IssueTracking issueTracking;
    private final long requirementsWithoutTests;
    private final long estimatedUnimplementedTests;
    private final EnvironmentVariables environmentVariables;

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, long requirementsWithoutTests, long estimatedUnimplementedTests, IssueTracking issueTracking) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
        this.requirementsWithoutTests = requirementsWithoutTests;
        this.estimatedUnimplementedTests = estimatedUnimplementedTests;
        this.issueTracking = issueTracking;
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this(requirement, testOutcomes, 0L, 0L, issueTracking);
    }

    public RequirementOutcome withTestOutcomes(TestOutcomes testOutcomes) {
        return new RequirementOutcome(this.requirement, testOutcomes, this.requirementsWithoutTests, this.estimatedUnimplementedTests, this.issueTracking);
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    private boolean hasUndefinedScenarios() {
        return this.requirement.getScenarioTags() != null && this.requirement.getScenarioTags().size() > this.testOutcomes.getTestCaseCount();
    }

    public boolean isComplete() {
        return !this.getTestOutcomes().getTests().isEmpty() && !this.hasUndefinedScenarios() && this.getTestOutcomes().getResult() == TestResult.SUCCESS && this.allChildRequirementsAreSuccessful();
    }

    public boolean isFailure() {
        return this.getTestOutcomes().getResult() == TestResult.FAILURE || this.anyChildRequirementsAreFailures();
    }

    public boolean isError() {
        return this.getTestOutcomes().getResult() == TestResult.ERROR || this.anyChildRequirementsAreErrors();
    }

    public boolean isCompromised() {
        return this.getTestOutcomes().getResult() == TestResult.COMPROMISED || this.anyChildRequirementsAreCompromised();
    }

    public boolean isPending() {
        return this.hasUndefinedScenarios() || this.getTestOutcomes().getResult() == TestResult.PENDING || this.anyChildRequirementsArePending();
    }

    public boolean isIgnored() {
        return this.getTestOutcomes().getResult() == TestResult.IGNORED || this.anyChildRequirementsAreIgnored();
    }

    public boolean isSkipped() {
        return this.getTestOutcomes().getResult() == TestResult.SKIPPED || this.anyChildRequirementsAreSkipped();
    }

    public int getFlattenedRequirementCount() {
        return this.getFlattenedRequirements().size();
    }

    public List<Requirement> getFlattenedRequirements() {
        ArrayList<Requirement> flattenedRequirements = new ArrayList<Requirement>();
        flattenedRequirements.add(this.requirement);
        flattenedRequirements.addAll(this.requirement.getNestedChildren());
        return NewList.copyOf(flattenedRequirements);
    }

    public List<Requirement> getFlattenedRequirements(Requirement ... excludingRequirement) {
        ArrayList<Requirement> flattenedRequirements = new ArrayList<Requirement>();
        flattenedRequirements.add(this.requirement);
        flattenedRequirements.addAll(this.requirement.getNestedChildren());
        flattenedRequirements.removeAll(NewList.of(excludingRequirement));
        return NewList.copyOf(flattenedRequirements);
    }

    public long getRequirementsWithoutTestsCount() {
        return this.requirementsWithoutTests;
    }

    private boolean allChildRequirementsAreSuccessful() {
        if (this.requirement.hasChildren()) {
            return this.allChildRequirementsAreSuccessfulFor(this.requirement.getChildren());
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailures() {
        return this.anyChildRequirementsAreFailuresFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsAreErrors() {
        return this.anyChildRequirementsAreErrorsFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsAreCompromised() {
        return this.anyChildRequirementsAreCompromisedFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsArePending() {
        return this.anyChildRequirementsArePendingFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsAreIgnored() {
        return this.anyChildRequirementsAreIgnoredFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsAreSkipped() {
        return this.anyChildRequirementsAreSkippedFor(this.requirement.getChildren());
    }

    private boolean allChildRequirementsAreSuccessfulFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (!childOutcomes.isComplete()) {
                return false;
            }
            if (this.allChildRequirementsAreSuccessfulFor(childRequirement.getChildren())) continue;
            return false;
        }
        return true;
    }

    private boolean anyChildRequirementsAreErrorsFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isError()) {
                return true;
            }
            if (!this.anyChildRequirementsAreErrorsFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsAreFailuresFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isFailure()) {
                return true;
            }
            if (!this.anyChildRequirementsAreFailuresFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsAreCompromisedFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isCompromised()) {
                return true;
            }
            if (!this.anyChildRequirementsAreErrorsFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsArePendingFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isPending()) {
                return true;
            }
            if (!this.anyChildRequirementsArePendingFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsAreIgnoredFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isIgnored()) {
                return true;
            }
            if (!this.anyChildRequirementsAreIgnoredFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsAreSkippedFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isSkipped()) {
                return true;
            }
            if (!this.anyChildRequirementsAreIgnoredFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    public String getCardNumberWithLinks() {
        if (this.requirement.getCardNumber() != null) {
            return new ReportFormatter(this.issueTracking).addLinks(this.requirement.getCardNumber());
        }
        return "";
    }

    public String toString() {
        return "RequirementOutcome{requirement=" + this.requirement + ", testOutcomes=" + this.testOutcomes + '}';
    }

    public int getTestCaseCount() {
        return this.testOutcomes.getTestCaseCount();
    }

    public int getScenarioCount() {
        return this.testOutcomes.getScenarioCount();
    }

    public int getTestCount() {
        return this.testOutcomes.getTotal();
    }

    public TestOutcomes getTests() {
        return this.testOutcomes;
    }

    public long getEstimatedUnimplementedTests() {
        return this.estimatedUnimplementedTests;
    }

    private long totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.testOutcomes.getTotal();
        return (long)totalImplementedTests + this.estimatedUnimplementedTests;
    }

    public RequirementsPercentageFormatter getFormattedPercentage() {
        return this.getFormattedPercentage(TestType.ANY);
    }

    public RequirementsPercentageFormatter getFormattedPercentage(String testType) {
        return new RequirementsPercentageFormatter(this.percentage(testType));
    }

    public RequirementsPercentageFormatter getFormattedPercentage(TestType testType) {
        return new RequirementsPercentageFormatter(this.percentage(testType));
    }

    public boolean testsRequirement(Requirement requirement) {
        return requirement.equals(this.getRequirement()) || this.testOutcomes.containsTag(requirement.asTag());
    }

    public RequirementsProportionCounter getPercent() {
        return this.percentage(TestType.ANY);
    }

    public PercentageRequirementCounter getPercentRequirements() {
        return new PercentageRequirementCounter(this.requirement, this.testOutcomes);
    }

    public SubrequirementsCount getSubrequirements() {
        return new SubrequirementsCount(this.requirement, this.testOutcomes);
    }

    public RequirementsProportionCounter percentage(String testType) {
        return this.percentage(TestType.valueOf(testType.toUpperCase()));
    }

    public RequirementsProportionCounter percentage(TestType testType) {
        return new RequirementsProportionCounter(testType, this.testOutcomes, this.totalEstimatedAndImplementedTests());
    }

    public OutcomeCounter getTotal() {
        return new OutcomeCounter(TestType.ANY);
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType);
    }

    public OutcomeCounter count(String testType) {
        return new OutcomeCounter(TestType.valueOf(testType.toUpperCase()));
    }

    public Set<String> getReleaseVersions() {
        HashSet<String> releaseVersions = new HashSet<String>();
        for (TestOutcome testOutcome : this.getTestOutcomes().getOutcomes()) {
            releaseVersions.addAll(testOutcome.getVersions());
        }
        return NewSet.copyOf(releaseVersions);
    }

    public RequirementOutcome withoutUnrelatedRequirements() {
        if (!this.shouldPrune(this)) {
            return this;
        }
        List<Requirement> childRequirementsWithTests = this.getRequirement().getChildren().stream().filter(this::isTested).collect(Collectors.toList());
        Requirement prunedRequirement = this.getRequirement().withChildren(childRequirementsWithTests);
        return new RequirementOutcome(prunedRequirement, this.testOutcomes, this.requirementsWithoutTests, this.estimatedUnimplementedTests, this.issueTracking);
    }

    public RequirementOutcome filteredByDisplayTag() {
        List<Requirement> childRequirementsWithMatchingTag = this.getRequirement().getChildren().stream().filter(this::isAllowedByDisplayTagConfiguration).collect(Collectors.toList());
        Requirement filteredRequirement = this.getRequirement().withChildren(childRequirementsWithMatchingTag);
        return new RequirementOutcome(filteredRequirement, this.testOutcomes, this.requirementsWithoutTests, this.estimatedUnimplementedTests, this.issueTracking);
    }

    public boolean shouldPrune(RequirementOutcome requirementOutcome) {
        return ExcludedUnrelatedRequirementTypes.definedIn(this.environmentVariables).excludeUntestedChildrenOfRequirementOfType(requirementOutcome.getRequirement().getType());
    }

    private boolean isTested(Requirement childRequirement) {
        return !this.testOutcomes.forRequirement(childRequirement).getOutcomes().isEmpty();
    }

    private boolean isAllowedByDisplayTagConfiguration(Requirement childRequirement) {
        RequirementsFilter requirementsFilter = new RequirementsFilter(this.environmentVariables);
        return requirementsFilter.inDisplayOnlyTags(childRequirement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementOutcome that = (RequirementOutcome)o;
        return this.requirement != null ? this.requirement.equals(that.requirement) : that.requirement == null;
    }

    public int hashCode() {
        return this.requirement != null ? this.requirement.hashCode() : 0;
    }

    public class OutcomeCounter
    extends TestOutcomeCounter {
        public OutcomeCounter(TestType testType) {
            super(testType);
        }

        public int withResult(String expectedResult) {
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        public int withResult(TestResult expectedResult) {
            return RequirementOutcome.this.testOutcomes.getOutcomes().stream().mapToInt(outcome -> outcome.countResults(expectedResult, this.testType)).sum();
        }

        public int withIndeterminateResult() {
            return RequirementOutcome.this.testOutcomes.getTotal() - this.withResult(TestResult.SUCCESS) - this.withResult(TestResult.FAILURE) - this.withResult(TestResult.ERROR);
        }

        public int withFailureOrError() {
            return this.withResult(TestResult.FAILURE) + this.withResult(TestResult.ERROR) + this.withResult(TestResult.COMPROMISED);
        }

        public int withAnyResult() {
            return RequirementOutcome.this.testOutcomes.getTotal();
        }
    }
}

